/*
 * Decompiled with CFR 0.152.
 */
package renderer;

import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import renderer.TextureCollection;
import renderer.VBO;
import renderer.shader.ShaderCollection;

public class CubicBSpline {
    private float[] controlPoints;
    private int numSamples;
    private int textureOffset;
    private float splineThickness = 1.5f;

    public void loadControlPoints2D(float beta, float[] points, int numSamples, TextureCollection textures, VBO vbo) {
        float[] toAdd = this.control2Dto3D(points);
        this.loadControlPoints3D(beta, toAdd, numSamples, textures, vbo);
    }

    public void loadControlPoints2D(float[] points, int numSamples, TextureCollection textures, VBO vbo) {
        float[] toAdd = this.control2Dto3D(points);
        this.loadControlPoints3D(toAdd, numSamples, textures, vbo);
    }

    private float[] control2Dto3D(float[] points) {
        float[] toAdd = new float[points.length / 2 * 3];
        int i = 0;
        while (i < toAdd.length) {
            toAdd[i] = points[i / 3 * 2];
            toAdd[i + 1] = points[i / 3 * 2 + 1];
            toAdd[i + 2] = 0.0f;
            i += 3;
        }
        return toAdd;
    }

    public void loadControlPoints3D(float beta, float[] points, int numSamples, TextureCollection textures, VBO vbo) {
        this.loadControlPoints3D(this.straightenSpline(beta, points), numSamples, textures, vbo);
    }

    public void loadControlPoints3D(float[] points, int numSamples, TextureCollection textures, VBO vbo) {
        this.numSamples = numSamples;
        this.loadVBO(vbo);
        float[] first = Arrays.copyOf(points, 3);
        float[] last = Arrays.copyOfRange(points, points.length - 3, points.length);
        this.controlPoints = new float[6 + points.length + 6];
        int i = 0;
        while (i < 6) {
            this.controlPoints[i] = first[i % 3];
            ++i;
        }
        i = 0;
        while (i < points.length) {
            this.controlPoints[i + 6] = points[i];
            ++i;
        }
        i = 0;
        while (i < 6) {
            this.controlPoints[points.length + 6 + i] = last[i % 3];
            ++i;
        }
        this.subDivide3D(this.controlPoints, textures);
    }

    private void loadVBO(VBO vbo) {
        FloatBuffer vertices = BufferUtils.createFloatBuffer((int)(3 * this.numSamples));
        float[] verts = new float[3 * this.numSamples];
        int i = 0;
        while (i < verts.length) {
            verts[i] = (float)i / (float)(verts.length - 3);
            verts[i + 1] = 0.5f;
            verts[i + 2] = 0.0f;
            i += 3;
        }
        vertices.put(verts);
        vertices.flip();
        FloatBuffer colors = BufferUtils.createFloatBuffer((int)(3 * this.numSamples));
        float[] cols = new float[3 * this.numSamples];
        int i2 = 0;
        while (i2 < cols.length) {
            cols[i2] = 1.0f;
            cols[i2 + 1] = 0.0f;
            cols[i2 + 2] = 0.0f;
            i2 += 3;
        }
        colors.put(cols);
        colors.flip();
        ShortBuffer indices = BufferUtils.createShortBuffer((int)this.numSamples);
        short[] inds = new short[this.numSamples];
        int i3 = 0;
        while (i3 < inds.length) {
            inds[i3] = (short)i3;
            ++i3;
        }
        indices.put(inds);
        indices.flip();
        vbo.init(0, vertices, colors, indices);
    }

    private void subDivide3D(float[] points, TextureCollection textures) {
        this.textureOffset = textures.getSize();
        int i = 0;
        while (i < points.length / 3 - 3) {
            float[] subArray = Arrays.copyOfRange(points, 3 * i, 3 * i + 12);
            textures.addTextureQueue(subArray, subArray.length / 3, 1);
            ++i;
        }
    }

    private float[] straightenSpline(float beta, float[] points) {
        int li = points.length - 3;
        float[] out = (float[])points.clone();
        int i = 0;
        while (i < points.length) {
            out[i] = beta * points[i] + (1.0f - beta) * (points[0] + (float)(i / 3) / (float)(points.length / 3 - 1) * (points[li] - points[0]));
            out[i + 1] = beta * points[i + 1] + (1.0f - beta) * (points[1] + (float)(i / 3) / (float)(points.length / 3 - 1) * (points[li + 1] - points[1]));
            out[i + 2] = beta * points[i + 2] + (1.0f - beta) * (points[2] + (float)(i / 3) / (float)(points.length / 3 - 1) * (points[li + 2] - points[2]));
            i += 3;
        }
        return out;
    }

    public void drawSpline(float[] viewMatrix, TextureCollection textures, ShaderCollection shaders, VBO vbo, float colorOverride) {
        float[] modelMatrix = (float[])viewMatrix.clone();
        float alpha = 0.05f + 0.05f * (float)Math.pow(6.0, 1.0) / (float)Math.pow((float)this.controlPoints.length / 3.0f, 1.0);
        if (colorOverride == 0.0f) {
            alpha *= 0.075f;
            GL11.glLineWidth((float)(this.splineThickness / 2.0f));
        } else {
            alpha *= 2.0f;
            GL11.glLineWidth((float)this.splineThickness);
        }
        shaders.bind(0);
        int i = 0;
        while (i < this.controlPoints.length / 3 - 3) {
            textures.bind_texture(this.textureOffset + i);
            shaders.setShaderParameters("controlPoints", 0, "modelMatrix", modelMatrix, "colorOffset", Float.valueOf((float)i * 1.0f / ((float)this.controlPoints.length / 3.0f - 3.0f)), "colorScale", Float.valueOf(1.0f / ((float)this.controlPoints.length / 3.0f - 3.0f)), "colorOverride", Float.valueOf(colorOverride), "alpha", Float.valueOf(alpha));
            vbo.render(0, 3, this.numSamples, 0, shaders);
            ++i;
        }
        shaders.unbind(0);
    }

    public void setSplineThickness(float thickness) {
        this.splineThickness = thickness;
    }

    public int getSize() {
        return this.controlPoints.length / 3;
    }
}

