/*
 * Decompiled with CFR 0.152.
 */
package com.infovis.callgraph;

import com.infovis.callgraph.CallBackInterface;
import graph.CompoundGraph;
import graph.HierarchyGraph;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;
import renderer.RenderThread;

public class CallGraphView
extends ViewPart
implements ActionListener,
ItemListener,
CallBackInterface {
    private static final String FILEEXTENSION = "java";
    private Composite composite;
    private Canvas canvas;
    private JLabel outputString = new JLabel("0 active edges");
    private JComboBox<String> projectList;
    private JComboBox<String> sizeList;
    private JComboBox<String> splineList;
    private JProgressBar progressBar;
    private JCheckBox contextCheckBox;
    private CompoundGraph cGraph;
    private RenderThread renderer;
    private boolean drawMixed = false;

    private void initGL() {
        this.renderer = new RenderThread(this.canvas, 500, 250, this);
        this.renderer.start();
    }

    public void createPartControl(Composite parent) {
        this.composite = new Composite(parent, 0x1000000);
        Frame frame = SWT_AWT.new_Frame((Composite)this.composite);
        frame.setLayout(new BorderLayout());
        this.canvas = new Canvas();
        this.canvas.setFocusable(true);
        frame.add((Component)this.canvas, "Center");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        JPanel leftPanel = new JPanel(new FlowLayout(0));
        panel.add(leftPanel);
        JPanel rightPanel = new JPanel(new FlowLayout(2));
        panel.add(rightPanel);
        this.initGL();
        String[] projects = this.init(0);
        this.projectList = new JComboBox<String>(projects);
        this.projectList.setSelectedIndex(0);
        leftPanel.add(this.projectList);
        JButton refreshButton = new JButton("Refresh");
        refreshButton.addActionListener(this);
        refreshButton.setActionCommand("refresh");
        leftPanel.add(refreshButton);
        leftPanel.add(this.outputString);
        leftPanel.add(Box.createHorizontalStrut(40));
        leftPanel.add(new JLabel("Text size: "));
        this.sizeList = new JComboBox<String>(new String[]{"tiny", "small", "medium", "large", "mixed"});
        this.sizeList.addActionListener(this);
        this.sizeList.setSelectedIndex(1);
        this.sizeList.setActionCommand("setText");
        leftPanel.add(this.sizeList);
        leftPanel.add(new JLabel("Spline thickness: "));
        this.splineList = new JComboBox<String>(new String[]{"thin", "medium", "thick"});
        this.splineList.setSelectedIndex(1);
        this.splineList.addActionListener(this);
        this.splineList.setActionCommand("setSpline");
        leftPanel.add(this.splineList);
        this.contextCheckBox = new JCheckBox("Context");
        this.contextCheckBox.setHorizontalTextPosition(2);
        this.contextCheckBox.setSelected(false);
        this.contextCheckBox.addItemListener(this);
        leftPanel.add(this.contextCheckBox);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(100);
        this.progressBar.setStringPainted(true);
        rightPanel.add(this.progressBar);
        frame.add((Component)panel, "South");
    }

    private String[] init(int project) {
        IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = myWorkspaceRoot.getProjects();
        if (projects.length > project) {
            this.processProject(projects[project]);
        }
        String[] out = new String[projects.length];
        int i = 0;
        while (i < projects.length) {
            out[i] = projects[i].getName();
            ++i;
        }
        return out;
    }

    private String processProject(IProject project) {
        if (!project.isOpen()) {
            try {
                project.open(null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        this.cGraph = new CompoundGraph();
        System.out.println("--------------------------");
        System.out.println("Generating Hierarchy Graph");
        System.out.println("--------------------------");
        IFolder srcFolder = project.getFolder("src");
        HierarchyGraph.HNode root = this.cGraph.addHierarchyRoot(srcFolder.getName());
        this.addNodesToGraph(srcFolder, root);
        this.cGraph.layoutHierarchyGraph();
        float[] points = this.cGraph.getHierarchyPoints();
        String[] labels = this.cGraph.getHierarchyPointLabels();
        boolean[] isLeaf = this.cGraph.getHierarchyisLeaf();
        System.out.println("");
        System.out.println("---------------------------");
        System.out.println("Generating Connection Graph");
        System.out.println("---------------------------");
        IJavaProject jProject = JavaCore.create((IProject)project);
        IPackageFragment[] packages = null;
        try {
            packages = jProject.getPackageFragments();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        int count = 0;
        int i = 0;
        while (i < packages.length) {
            try {
                if (packages[i].getKind() == 1) {
                    ++count;
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            ++i;
        }
        if (this.progressBar != null) {
            this.progressBar.setMaximum(count);
        }
        count = 0;
        i = 0;
        while (i < packages.length) {
            try {
                if (packages[i].getKind() == 1) {
                    this.getPackages(packages[i]);
                }
                if (this.progressBar != null) {
                    this.progressBar.setValue(count++);
                    this.progressBar.update(this.progressBar.getGraphics());
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            ++i;
        }
        this.renderer.setGraph(points, labels, isLeaf, this.cGraph.getEdges(), this.cGraph.getHierarchyEdges());
        return project.getName();
    }

    private void getPackages(IPackageFragment p) {
        ArrayList<String> path = new ArrayList<String>();
        path.add("src");
        String directory = p.getElementName();
        String[] directories = directory.split("[\\.]");
        Collections.addAll(path, directories);
        int i = 0;
        while (i < path.size()) {
            if (((String)path.get(i)).equals("")) {
                path.remove(i);
                --i;
            }
            ++i;
        }
        try {
            ICompilationUnit[] units = p.getCompilationUnits();
            int i2 = 0;
            while (i2 < units.length) {
                this.getClasses(units[i2], new ArrayList<String>(path));
                ++i2;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private void getClasses(ICompilationUnit unit, ArrayList<String> path) {
        try {
            IType[] types;
            IType[] iTypeArray = types = unit.getAllTypes();
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                path.add(type.getElementName());
                this.getMethods(type, new ArrayList<String>(path));
                ++n2;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private void getMethods(IType type, ArrayList<String> path) {
        try {
            IMethod[] methods;
            IMethod[] iMethodArray = methods = type.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Integer size;
                IMethod method = iMethodArray[n2];
                SearchPattern pattern = SearchPattern.createPattern((IJavaElement)method, (int)2);
                IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
                SearchImplementation requestor = new SearchImplementation();
                SearchEngine searchEngine = new SearchEngine();
                searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)requestor, null);
                while ((size = requestor.getResultsSize()) == null) {
                }
                int i = 0;
                while (i < size) {
                    this.cGraph.addConnectionEdge(method.getElementName(), requestor.getResult(i), path.toArray(new String[path.size()]));
                    ++i;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void addNodesToGraph(IFolder rootFolder, HierarchyGraph.HNode parent) {
        IResource[] files = null;
        try {
            files = rootFolder.members();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < files.length) {
            if (files[i].getType() == 1 && files[i].getFileExtension().equals(FILEEXTENSION)) {
                this.cGraph.addHierarchyNode(parent, files[i].getName());
            }
            if (files[i].getType() == 2) {
                HierarchyGraph.HNode nParent = this.cGraph.addHierarchyNode(parent, files[i].getName());
                this.addNodesToGraph((IFolder)files[i], nParent);
            }
            ++i;
        }
    }

    public void setFocus() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("refresh")) {
            this.init(this.projectList.getSelectedIndex());
        } else if (e.getActionCommand().equals("setText")) {
            int index = this.sizeList.getSelectedIndex();
            this.drawMixed = false;
            switch (index) {
                case 0: {
                    this.renderer.setTextSize(0.085f);
                    break;
                }
                case 1: {
                    this.renderer.setTextSize(0.12f);
                    break;
                }
                case 2: {
                    this.renderer.setTextSize(0.15f);
                    break;
                }
                case 3: {
                    this.renderer.setTextSize(0.2f);
                    break;
                }
                case 4: {
                    this.drawMixed = true;
                    break;
                }
            }
            this.renderer.setDrawMixed(this.drawMixed);
        } else if (e.getActionCommand().equals("setSpline")) {
            int index = this.splineList.getSelectedIndex();
            switch (index) {
                case 0: {
                    this.renderer.setSplineThickness(1.25f);
                    break;
                }
                case 1: {
                    this.renderer.setSplineThickness(1.75f);
                    break;
                }
                case 2: {
                    this.renderer.setSplineThickness(2.25f);
                    break;
                }
            }
        }
    }

    @Override
    public void setActiveEdgeCount(int count) {
        this.outputString.setText(String.valueOf(count) + " active edges");
    }

    @Override
    public void setActiveText(String text) {
        this.outputString.setText(text);
    }

    @Override
    public void setStatus(int current, int maximum) {
        this.progressBar.setValue(current);
        this.progressBar.setMaximum(maximum);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.contextCheckBox) {
            this.renderer.setSplineContext(this.contextCheckBox.isSelected());
        }
    }

    private class SearchImplementation
    extends SearchRequestor {
        private boolean isFinished;
        private ArrayList<ArrayList<String>> results;

        private SearchImplementation() {
        }

        private void addResult(ArrayList<String> nRes) {
            this.results.add(nRes);
        }

        public Integer getResultsSize() {
            if (!this.isFinished) {
                return null;
            }
            return this.results.size();
        }

        public String[] getResult(int index) {
            return this.results.get(index).toArray(new String[this.results.get(index).size()]);
        }

        public void beginReporting() {
            super.beginReporting();
            this.results = new ArrayList();
            this.isFinished = false;
        }

        public void endReporting() {
            super.endReporting();
            this.isFinished = true;
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            if (match.getElement() instanceof IMethod) {
                IMethod caller = (IMethod)match.getElement();
                ArrayList<String> newResult = new ArrayList<String>();
                String parent = "";
                IJavaElement ele = caller.getParent().getParent();
                while (ele != null) {
                    if (!ele.getElementName().equals("")) {
                        parent = String.valueOf(ele.getElementName()) + "/" + parent;
                        String name = ele.getElementName();
                        String[] subStrings = name.split("\\.");
                        if (subStrings[subStrings.length - 1].equals(CallGraphView.FILEEXTENSION)) {
                            subStrings = Arrays.copyOf(subStrings, subStrings.length - 1);
                        }
                        int i = subStrings.length - 1;
                        while (i >= 0) {
                            newResult.add(subStrings[i]);
                            --i;
                        }
                    }
                    ele = ele.getParent();
                }
                parent = parent.substring(0, parent.length() - 6);
                this.addResult(newResult);
            }
        }
    }
}

