varying vec3 lightDir;
varying vec4 worldpos;
varying vec3 halfVector;

void main(void)
{
	gl_Position = ftransform();
	mat4 modelMat = gl_TextureMatrix[6] * gl_ModelViewMatrix;
	worldpos = modelMat * gl_Vertex;

	vec4 lightpos = gl_LightSource[0].position;
	vec4 pos = modelMat * gl_Vertex;
	lightDir = lightpos.xyz-pos.xyz;
	halfVector = normalize(gl_LightSource[0].halfVector.xyz);
	gl_FrontColor = gl_Color;
}
