uniform int light_type;
varying vec3 lightDir;
varying vec4 worldpos;
varying vec3 halfVector;

void main(void)
{
	vec3 lightdir = normalize(lightDir);

	vec4 color = gl_Color;

	float spot = 1.0;		
	switch(light_type)
	{
	case 0:	//Point Light
		spot = clamp((length(gl_LightSource[0].position.xyz-worldpos.xyz)/2.0f - gl_LightSource[0].constantAttenuation) / (gl_LightSource[0].spotCutoff - gl_LightSource[0].constantAttenuation), 0.0, 1.0);
		break;	
	case 1:	//Cone Light
		spot = clamp((length(gl_LightSource[0].position.xz-worldpos.xz)/2.0f - gl_LightSource[0].constantAttenuation) / (gl_LightSource[0].spotCutoff - gl_LightSource[0].constantAttenuation), 0.0, 1.0);
		break;
	case 2:	//Spot Light	
		float cos_outer_cone_angle = cos(gl_LightSource[0].constantAttenuation);
		float cos_inner_cone_angle = gl_LightSource[0].spotCosCutoff;
		float cos_inner_minus_outer_angle = cos_inner_cone_angle - cos_outer_cone_angle;
		float cos_cur_angle = dot(-lightdir, normalize(gl_LightSource[0].spotDirection));
		spot = clamp((cos_cur_angle - cos_outer_cone_angle) / cos_inner_minus_outer_angle, 0.0, 1.0);
		break;
	}

	color.xyz = color.xyz * spot;
	gl_FragColor = vec4(color.rgb * color.a, color.a);
}