varying vec4 v_position;

void main()
{
	float depth = v_position.z / v_position.w;
	
	// Don't forget to move away from unit cube ([-1,1]) to [0,1] coordinate system
	depth = depth*0.5 + 0.5;

	// TODO ARTR: store first and second moment into shadow map
	float dx = dFdx(depth);
	float dy = dFdy(depth);
	float moment = pow(depth,2.0) + (0.25*(pow(dx,2.0), + pow(dy,2.0)));
	gl_FragColor = vec4(depth, moment, 0.0, 0.0);
}