varying vec3 lightDir;
varying vec3 normal;
varying vec3 halfVector;
varying float dist;
varying vec4 ShadowCoord;
varying vec4 position;
varying vec4 worldpos;
varying vec4 id;

void main(void)
{
	mat4 modelMat = gl_TextureMatrix[6] * gl_ModelViewMatrix;

	worldpos = modelMat * gl_Vertex;

	normal = normalize(gl_NormalMatrix * gl_Normal);

	vec4 lightpos = gl_LightSource[0].position;
	vec4 pos = modelMat * gl_Vertex;

	lightDir = gl_LightSource[0].position.xyz-pos.xyz;	

	dist = length(lightDir);
	lightDir = normalize(lightDir);
	halfVector = normalize(gl_LightSource[0].halfVector.xyz);

	ShadowCoord = gl_TextureMatrix[7] * gl_ModelViewMatrix * gl_Vertex;
	gl_TexCoord[0] = gl_MultiTexCoord0;
	gl_Position = ftransform();
	gl_FrontColor = gl_Color;

	position = gl_ModelViewMatrix * gl_Vertex;

	id = gl_MultiTexCoord0;

}