#ifndef WINDOW_H
#define WINDOW_H

#include <QtGui\QWidget>
#include <QtGui\QtGui>
#include <Qt\Q3FileDialog.h>

#include "GLWidget.h"
#include <vector>

class GLWidget;

/** Contains the GUI elements */
class Window : public QWidget {
	Q_OBJECT 
   
	public:
		/** Constructor of window class. It generates the user interface that is split up into manipulation stuff 
		  * for user and the paint window. */
		 Window();

	private:
		
		// ------ VARIABLES ------
		
		/** window for painting */
	   GLWidget *glWidget;

		/** tablar for four view data, map, bar chart and pie chart */
		QTabWidget *tabView;

		/** window for QTabWidget for loading data */
		QWidget *loadTab;
		
		/** window for QTabWidget for manipulation landscape plane(s) */
		QWidget *landTab;

		/** window for QTabWidget for manipulation bar chart plane(s) */
		QWidget *barTab;

		/** window for QTabWidget for manipulation pie chart plane(s) */
		QWidget *pieTab;

		/** combobox for adding a map */
		QComboBox *cbLandAdd;

		/** combobox for adding a bar chart */
		QComboBox *cbBarAdd;

		/** combobox for adding a pie chart */
		QComboBox *cbPieAdd;
		
		/** combobox that contains chosed columns for adding a map */
		QComboBox *cbLandActAdd;
		
		/** combobox that contains chosed columns for adding a bar chart */
		QComboBox *cbBarActAdd;
		
		/** combobox that contains chosed columns for adding a pie chart */
		QComboBox *cbPieActAdd;
	
		/** combobox that contains choosen columns for editing */
		QComboBox *cbBarEdit;

		/** combobox that removes choosen map */
		QComboBox *cbLandRemove;

		/** combobox that removes choosen bar chart */
		QComboBox *cbBarRemove;

		/** combobox that removes choosen pie chart */
		QComboBox *cbPieRemove;
		
		/** lineedit for path of selected data file */
		QLineEdit *txtPath;

		
		/** lineEdit for x position of new map */
		QLineEdit *txtLandX;
		
		/** lineEdit for y position of new map */
		QLineEdit *txtLandY;
		
		/** lineEdit for z position of new map */
		QLineEdit *txtLandZ;
		
		/** lineEdit for x rotation of new map */
		QLineEdit *txtLandRotX;
		
		/** lineEdit for y rotation of new map */
		QLineEdit *txtLandRotY;

		/** lineEdit for x position of new bar chart */
		QLineEdit *txtBarX;

		/** lineEdit for y position of new bar chart */
		QLineEdit *txtBarY;
		
		/** lineEdit for z position of new bar chart */
		QLineEdit *txtBarZ;

		/** lineEdit for x rotation of new bar chart */
		QLineEdit *txtBarRotX;

		/** lineEdit for y position of new bar chart */
		QLineEdit *txtBarRotY;


		/** lineEdit for x position of new pie chart */
		QLineEdit *txtPieX;
		
		/** lineEdit for y position of new pie chart */
		QLineEdit *txtPieY;
		
		/** lineEdit for z rotation of new pie chart */
		QLineEdit *txtPieZ;
		
		/** lineEdit for x rotation of new pie chart */
		QLineEdit *txtPieRotX;

		/** lineEdit for y rotation of new pie chart */
		QLineEdit *txtPieRotY;


		/** pushbutton for animating a map from 2D to 3D or 3D to 2D */ 
		QPushButton *bAnimateMap;
		
		/** pushbutton for animating a bar chart from 2D to 3D or 3D to 2D */
		QPushButton *bAnimateBar;
		
		/** pushbutton for animating a pie chart from 2D to 3D or 3D to 2D */
		QPushButton *bAnimatePie;


		
		/** pushbutton for removing a choosen map */
		QPushButton *bMapRemove;

		/** pushbutton for removing a choosen bar chart */
		QPushButton *bBarRemove;
		
		/** pushbutton for removing a choosen pie chart */
		QPushButton *bPieRemove;


		/** pushbutton for adding a new map */
		QPushButton *bMapAdd;

		/** pushbutton for adding a new bar chart */
		QPushButton *bBarAdd;

		/** pushbutton for adding a new pie chart */
		QPushButton *bPieAdd;

		
		/** if 2D animation is active */
		bool animate2D;

		/** actual count of how many maps were added */
		int cntMap;
		
		/** actual count of how many bar charts were added */
		int cntBar;
		
		/** actual count of how many pie charts were added */
		int cntPie;

		float x;
		float y;
		float z;

		// ------ METHODS ------


		/** initializes load part of QTabWidget */
		void initLoadTab();

		/** initializes landscape part of QTabWidget */
		void initLandTab();
		
		/** initializes bar chart part of QTabWidget */
		void initBarTab();
		
		/** initializes pie chart part of QTabWidget */
		void initPieTab();

		/** initializes pie, bar and landscape tab */
		void initTabs(QComboBox *cbAdd, QComboBox *cbActAdd, QPushButton *bAnimate, QComboBox *cbRemove, 
						  QLineEdit *txtX, QLineEdit *txtY, QLineEdit *txtZ, QLineEdit *txtRotX, 
						  QLineEdit *txtRotY, QWidget *tab, int char_type, QPushButton *bRemove, QPushButton *bAdd);
		
	public slots:
		/** loads data from file into our data structure by choosing a file by the help of filedialog */
		void setInputfile();

		/** adds new landscape plane to our environment */
		void addLandPlane();
		
		/** adds new bar chart plane to our environment */
		void addBarPlane();

		/** adds new pie chart plane to our environment */
		void addPiePlane();

		/** adds title for map plane */
		void addLandTitle();

		/** adds title for pie chart plane */
		void addPieTitle();

		/** delets choosen map plane */
		void removeLandPlane();

		/** delets choosen bar chart plane */
		void removeBarPlane();

		/** delets choosen pie chart plane */
		void removePiePlane();

		/** deletes item */
		void removeItem();

		/** removes selected pie element */
		void removeSelectedPieElement();

		/** animate map to 2D or 3D */
		void animateMap();

		/** animate pie chart to 2D or 3D */
		void animatePie();
		
		/** animate bar chart to 2D or 3D */
		void animateBar();

		/** set visibility of tabwidget if switch between 2D and 3D happened */
		void setVisibility();
};

#endif