#include "window.h"

using namespace std;


Window::Window() {
// constructor for window class
	
	// create new widget for painting
	glWidget = new GLWidget(this);

	// --- create control elements for user manipulation --- 
	QHBoxLayout *mainLayout = new QHBoxLayout;		// layout for control element and GLWidget
	
	cntMap = 0;
	cntPie = 0;
	cntBar = 0;
	

	animate2D = true;

	x = -2;
	y = 4;
	z = -10;

	// init the QTabWidget for load data, landscape, bar chart and pie chart
	initLoadTab();
	initPieTab();
	initBarTab();
	initLandTab();

	// create QTabWidget and set tabs
	tabView = new QTabWidget();
	
	tabView->insertTab(0, loadTab, "load data");
   tabView->insertTab(1, landTab, "landscape");
   tabView->insertTab(2, barTab, "bar chart");
   tabView->insertTab(3, pieTab, "pie chart");
   
	tabView->setTabPosition (QTabWidget::West);
	tabView->setMaximumWidth(325);

	// put all control elements to main layout
	mainLayout->addWidget(tabView);
	mainLayout->addWidget(glWidget,1);
	
	// set main layout and title
	setLayout(mainLayout);
	setWindowTitle(tr("VisLink"));

	connect(glWidget, SIGNAL(updateGUI(void)), this, SLOT(removeItem()));
	connect(glWidget, SIGNAL(visibleGUI(void)), this, SLOT(setVisibility()));
}


void Window::initLoadTab() {
// initializes load tab

	loadTab = new QWidget();

	QVBoxLayout *controlLayout = new QVBoxLayout;	// layout for control elements

	// control elements for load data
	txtPath = new QLineEdit("C:\\");		// create line edit
	txtPath->setMinimumWidth(150);
	QPushButton *bLoad = new QPushButton("...");		// create push button
	bLoad->setMaximumWidth(50);
	QGroupBox *gbLoad = new QGroupBox("load data");	// create group box for load data
	QGridLayout *gbLoadLayout = new QGridLayout();	// create layout for load data
	
	// put control elements for load data in gbload
	gbLoadLayout->addWidget(txtPath, 0, 0, 1, 3);
	gbLoadLayout->addWidget(bLoad, 0, 4, 1, 1);
	gbLoad->setLayout(gbLoadLayout);

	// put control element load to control layout
	controlLayout->addWidget(gbLoad);
	controlLayout->addStretch(1);

	loadTab->setLayout(controlLayout);


	// connect control elements to methods
	connect(bLoad, SIGNAL(clicked()), this, SLOT(setInputfile()));
}

void Window::initLandTab() {
// initializes landscape tab
	landTab = new QWidget();
	cbLandAdd = new QComboBox();
	cbLandActAdd = new QComboBox();
//	cbLandEdit = new QComboBox();
	cbLandRemove = new QComboBox();
	bAnimateMap = new QPushButton("to2D");
	bMapAdd = new QPushButton("add plane");	
	bMapRemove = new QPushButton("remove");

	txtLandX = new QLineEdit();
	txtLandY = new QLineEdit();
	txtLandZ = new QLineEdit();
	txtLandRotX = new QLineEdit();
	txtLandRotY = new QLineEdit();
	initTabs(cbLandAdd, cbLandActAdd, bAnimateMap, cbLandRemove, txtLandX, txtLandY, txtLandZ, txtLandRotX, txtLandRotY, 
				landTab, GLWidget::PLANE_MAP, bMapRemove, bMapAdd);
}

void Window::initBarTab() {
// initializes bar chart tab
	barTab = new QWidget();
	cbBarAdd = new QComboBox();
	cbBarActAdd = new QComboBox();
	cbBarEdit = new QComboBox();
	cbBarRemove = new QComboBox();
	bAnimateBar = new QPushButton("to2D");
	bBarAdd = new QPushButton("add plane");		// create push button
	bBarRemove = new QPushButton("remove");
	
	txtBarX = new QLineEdit();
	txtBarY = new QLineEdit();
	txtBarZ = new QLineEdit();
	txtBarRotX = new QLineEdit();
	txtBarRotY = new QLineEdit();

	initTabs(cbBarAdd, cbBarActAdd, bAnimateBar, cbBarRemove,  txtBarX, txtBarY, txtBarZ, txtBarRotX, txtBarRotY, 
				barTab, GLWidget::PLANE_BAR, bBarRemove, bBarAdd);
}

void Window::initPieTab() {
// initializes pie chart tab
	pieTab = new QWidget();
	cbPieAdd = new QComboBox();
	cbPieActAdd = new QComboBox();
//	cbPieEdit = new QComboBox();
	cbPieRemove = new QComboBox();
	bAnimatePie = new QPushButton("to2D");
	bPieAdd = new QPushButton("add plane");	
	bPieRemove = new QPushButton("remove");

	txtPieX = new QLineEdit();
	txtPieY = new QLineEdit();
	txtPieZ = new QLineEdit();
	txtPieRotX = new QLineEdit();
	txtPieRotY = new QLineEdit();
	initTabs(cbPieAdd, cbPieActAdd, bAnimatePie, cbPieRemove, txtPieX, txtPieY, txtPieZ, txtPieRotX, txtPieRotY, 
				pieTab, GLWidget::PLANE_PIE, bPieRemove, bPieAdd);
}

void Window::initTabs(QComboBox *cbAdd, QComboBox *cbActAdd, QPushButton *bAnimate, QComboBox *cbRemove, 
							 QLineEdit *txtX, QLineEdit *txtY, QLineEdit *txtZ, QLineEdit *txtRotX, 
							 QLineEdit *txtRotY, QWidget *tab, int char_type, QPushButton *bRemove, QPushButton *bAdd) {

	// layout for all control elements
	QVBoxLayout *controlLayout = new QVBoxLayout;

	QPushButton *bAddTitle = new QPushButton(">>");		// create push button
	bAddTitle->setMaximumWidth(40);

	QLabel *lX = new QLabel("postion x:");
	txtX->setMinimumWidth(30);
	txtX->setText(QString::number(x));
	QLabel *lY = new QLabel("position y:");
	txtY->setMinimumWidth(30);
	txtY->setText(QString::number(y));
	QLabel *lZ = new QLabel("position z:");
	txtZ->setMinimumWidth(30);
	txtZ->setText(QString::number(z)); // -7
	QLabel *lRotX = new QLabel("rotation x:");
	txtRotX->setMinimumWidth(30);
	txtRotX->setText("0");
	QLabel *lRotY = new QLabel("rotation y:");
	txtRotY->setMinimumWidth(30);
	txtRotY->setText("30"); // 30	

	QGroupBox *gbAdd = new QGroupBox("add new plane");	// create group box for load data
	QGridLayout *gbAddLayout = new QGridLayout();	// create layout for load data
	
	bAdd->setMaximumWidth(100);
	
	QPushButton *bRemoveTitle = new QPushButton("x");
	bRemoveTitle->setMaximumWidth(40);

	// put control elements for load data in gbload
	if (char_type == GLWidget::PLANE_BAR) {
		QLabel *lblAdd = new QLabel("title");
		lblAdd->setMaximumWidth(50);
		QLabel *lblActAdd = new QLabel("source");
		lblActAdd->setMaximumWidth(50);
		cbAdd->setMaximumWidth(115);
		cbActAdd->setMaximumWidth(115);

		gbAddLayout->addWidget(lblAdd, 0, 0, 1, 3);
		gbAddLayout->addWidget(cbAdd, 0, 3, 1, 1);
		gbAddLayout->addWidget(lblActAdd, 1, 0, 1, 3);
		gbAddLayout->addWidget(cbActAdd, 1, 3, 1, 1);	
	}
	else if (char_type == GLWidget::PLANE_PIE) {

		// control elements for add plane
		cbAdd->setMinimumWidth(135);
		cbActAdd->setMinimumWidth(135);

		
		gbAddLayout->addWidget(cbAdd, 0, 0, 1, 3);
		gbAddLayout->addWidget(bAddTitle, 0, 3, 1, 1);
		gbAddLayout->addWidget(cbActAdd, 1, 0, 1, 3);
		gbAddLayout->addWidget(bRemoveTitle, 1, 3, 1, 1);
	}
	gbAddLayout->addWidget(lX, 2, 0, 1, 3);
	gbAddLayout->addWidget(txtX, 2, 3, 1, 1);
	gbAddLayout->addWidget(lY, 3, 0, 1, 3);
	gbAddLayout->addWidget(txtY, 3, 3, 1, 1);
	gbAddLayout->addWidget(lZ, 4, 0, 1, 3);
	gbAddLayout->addWidget(txtZ, 4, 3, 1, 1);
	gbAddLayout->addWidget(lRotX, 5, 0, 1, 3);
	gbAddLayout->addWidget(txtRotX, 5, 3, 1, 1);
	gbAddLayout->addWidget(lRotY, 6, 0, 1, 3);
	gbAddLayout->addWidget(txtRotY, 6, 3, 1, 1);
	gbAddLayout->addWidget(bAdd, 7, 2, 1, 1);
	gbAdd->setLayout(gbAddLayout);
	
	// control elements for remove plane
	cbRemove->setMinimumWidth(135);
	bRemove->setMaximumWidth(50);


	

	QGroupBox *gbRemove = new QGroupBox("manipulate plane(s)");	// create group box for load data
	QGridLayout *gbRemoveLayout = new QGridLayout();	// create layout for load data
	
	// put control elements for load data in gbload
	gbRemoveLayout->addWidget(cbRemove, 0, 0, 1, 3);
	gbRemoveLayout->addWidget(bAnimate, 1, 0, 1, 3);
	gbRemoveLayout->addWidget(bRemove, 1, 3, 1, 1);
	gbRemove->setLayout(gbRemoveLayout);


	// put all panels to control element
	controlLayout->addWidget(gbAdd);
	controlLayout->addWidget(gbRemove);
	controlLayout->addStretch(1);

	tab->setLayout(controlLayout);

	switch(char_type) {
		case GLWidget::PLANE_MAP:	
		// add new landscape plane
					connect(bAddTitle, SIGNAL(clicked()), this, SLOT(addLandTitle()));
					connect(bAdd, SIGNAL(clicked()), this, SLOT(addLandPlane()));
					connect(bRemove, SIGNAL(clicked()), this, SLOT(removeLandPlane()));
					connect(bAnimate, SIGNAL(clicked()), this, SLOT(animateMap()));
					break;
		case GLWidget::PLANE_BAR:	
		// add new bar chart plane
					connect(bAdd, SIGNAL(clicked()), this, SLOT(addBarPlane()));
					connect(bRemove, SIGNAL(clicked()), this, SLOT(removeBarPlane()));
					connect(bAnimate, SIGNAL(clicked()), this, SLOT(animateBar()));
					break;
		case GLWidget::PLANE_PIE:	
		// add new pie chart plane
					connect(bAddTitle, SIGNAL(clicked()), this, SLOT(addPieTitle()));
					connect(bAdd, SIGNAL(clicked()), this, SLOT(addPiePlane()));
					connect(bRemove, SIGNAL(clicked()), this, SLOT(removePiePlane()));
					connect(bRemoveTitle, SIGNAL(clicked()), this, SLOT(removeSelectedPieElement()));
					connect(bAnimate, SIGNAL(clicked()), this, SLOT(animatePie()));
					break;
	}
}

void Window::setInputfile() {
// load data from file

	// get back directory that user had chosen
	QString dir = Q3FileDialog::getOpenFileName( "/.", "text (*.txt)", this, "open file dialog", 
																"Choose a file to open");

	// check if user chooses folder
	if (dir.length() > 0) {
		txtPath->setText(dir);
		bool ok = glWidget->loadData(dir);
			
		if (ok == true) {
			// get back title from loaded file
			vector<QString> vec = glWidget->getTitle();

			// if there exist items in combobox remove them
			while( cbPieAdd->count() > 0) {
				cbPieAdd->removeItem(0);
				cbBarActAdd->removeItem(0);
			}

			// delete all from title combobox of bar chart
			while( cbBarAdd->count() > 0) {
				cbBarAdd->removeItem(0);
			}

			// set back postion, rotation to initialise value
			x = -2;
			y = 4;
			z = -10;
			
			txtLandX->setText(QString::number(x));
			txtBarX->setText(QString::number(x));
			txtPieX->setText(QString::number(x));
			txtLandY->setText(QString::number(y));
			txtBarY->setText(QString::number(y));
			txtPieY->setText(QString::number(y));
			txtLandZ->setText(QString::number(z));
			txtBarZ->setText(QString::number(z));
			txtPieZ->setText(QString::number(z));

			cntMap = 0;
			cntPie = 0;
			cntBar = 0;
	
			// remove all planes
			while (cbPieRemove->count() > 0)
				removePiePlane();
			while (cbBarRemove->count() > 0)
				removeBarPlane();
			while (cbLandRemove->count() > 0)	
				removeLandPlane();


			vector<int> type = glWidget->getType();

			// add new title items to combobox
			for (int i=0; i < vec.size(); i++) {
				if (!(QString::compare(vec.at(i), "x") == 0 || QString::compare(vec.at(i), "y") == 0 || QString::compare(vec.at(i), "short") == 0)) {
					cbLandAdd->addItem(vec.at(i));
					// check for correct type -> show only usable columns that have correct types
					if (type.at(i) == GLWidget::TYPE_FLOAT || type.at(i) == GLWidget::TYPE_PERCENT) {
						cbPieAdd->addItem(vec.at(i));
						cbBarActAdd->addItem(vec.at(i));
					}
					// check for correct type -> show only usable columns that have correct types
					if (type.at(i) == GLWidget::TYPE_STRING) {
						cbBarAdd->addItem(vec.at(i));
					}
				}
			}
			tabView->setCurrentIndex(1);
		}
	}
}

void Window::addLandPlane() {
	// adds new land plane to our environment
	 vector<int> col;
	 vector<QString> title = glWidget->getTitle();

	 col.push_back(0);

	 // save also index of x and y values
	 col.push_back(2);
	 col.push_back(3);


	 glWidget->addPlane(GLWidget::PLANE_MAP, col, atoi(txtLandX->text().toLatin1()), atoi(txtLandY->text().toLatin1()), 
			  atoi(txtLandZ->text().toLatin1()), atoi(txtLandRotX->text().toLatin1()), atoi(txtLandRotY->text().toLatin1()));

	        
	 // update edit planes combobox 
	 cntMap++;
	 char buffer[10];
	 /*
	 itoa(cntMap, buffer, 10);
	 cbLandEdit->addItem("map: " + QString(buffer));
	 */

	 itoa(cntMap, buffer, 10);
	 cbLandRemove->addItem("map: " + QString(buffer));
	 
	 while (cbLandActAdd->count() > 0)
	    cbLandActAdd->removeItem(0);

 
	if (QString::compare(txtLandX->text(), QString::number(x)) == 0) {
		//x += 3;
		x+=2;
		txtLandX->setText(QString::number(x));
		txtBarX->setText(QString::number(x));
		txtPieX->setText(QString::number(x));
	}

	if (QString::compare(txtLandY->text(), QString::number(y)) == 0) {
		//y -= 2;
		y-=1;
		txtLandY->setText(QString::number(y));
		txtBarY->setText(QString::number(y));
		txtPieY->setText(QString::number(y));
	}

	if (QString::compare(txtLandZ->text(), QString::number(z)) == 0){
		//z += 2;
		z+=1;
		txtLandZ->setText(QString::number(z));
		txtBarZ->setText(QString::number(z));
		txtPieZ->setText(QString::number(z));
	}
}

void Window::addBarPlane() {
// adds new bar chart plane to our environment
	vector<int> col;
	vector<QString> title = glWidget->getTitle();

	// save column for title
	for (int j=0; j < title.size(); j++ ) {
		if (QString::compare(title.at(j), cbBarAdd->currentText()) == 0)
			col.push_back(j); 
	}

	// save column for source
	for (int j=0; j < title.size(); j++ ) {
		if (QString::compare(title.at(j), cbBarActAdd->currentText()) == 0)
			col.push_back(j); 
	}

	glWidget->addPlane(GLWidget::PLANE_BAR, col, atoi(txtBarX->text().toLatin1()), atoi(txtBarY->text().toLatin1()), 
							 atoi(txtBarZ->text().toLatin1()), atoi(txtBarRotX->text().toLatin1()), atoi(txtBarRotY->text().toLatin1()));

	// update edit planes combobox
	cntBar++;
	char buffer[10];
	/*
	itoa(cntBar, buffer, 10);
	cbBarEdit->addItem("bar chart: " + QString(buffer));
	*/

	itoa(cntBar, buffer, 10);
	cbBarRemove->addItem("bar chart: " + QString(buffer));

	
	if (QString::compare(txtBarX->text(), QString::number(x)) == 0) {
		x += 2;
		txtLandX->setText(QString::number(x));
		txtBarX->setText(QString::number(x));
		txtPieX->setText(QString::number(x));
	}

	if (QString::compare(txtBarY->text(), QString::number(y)) == 0) {
		y -= 1;
		txtLandY->setText(QString::number(y));
		txtBarY->setText(QString::number(y));
		txtPieY->setText(QString::number(y));
	}

	if (QString::compare(txtBarZ->text(), QString::number(z)) == 0){
		z += 1;
		txtLandZ->setText(QString::number(z));
		txtBarZ->setText(QString::number(z));
		txtPieZ->setText(QString::number(z));
	}
}

void Window::addPiePlane() {
// adds new pie chart plane to our environment
	vector<int> col;
	vector<QString> title = glWidget->getTitle();

	for (int i=0; i < cbPieActAdd->count(); i++) {
		cbPieActAdd->setCurrentIndex(i);
		for (int j=0; j < title.size(); j++ ) {
			if (QString::compare(title.at(j), cbPieActAdd->currentText()) == 0)
				col.push_back(j);
		}
	}

	if (col.size() > 0) {
		glWidget->addPlane(GLWidget::PLANE_PIE, col, atoi(txtPieX->text().toLatin1()), atoi(txtPieY->text().toLatin1()), 
								 atoi(txtPieZ->text().toLatin1()), atoi(txtPieRotX->text().toLatin1()), atoi(txtPieRotY->text().toLatin1()));

		// update edit planes combobox
		cntPie++;
		char buffer[10];
		/*
		itoa(cntPie, buffer, 10);
		cbPieEdit->addItem("pie chart: " + QString(buffer));
		*/

		itoa(cntPie, buffer, 10);
		cbPieRemove->addItem("pie chart: " + QString(buffer));
		
		while (cbPieActAdd->count() > 0)
			cbPieActAdd->removeItem(0);

		if (QString::compare(txtPieX->text(), QString::number(x)) == 0) {
			x += 2;
			txtLandX->setText(QString::number(x));
			txtBarX->setText(QString::number(x));
			txtPieX->setText(QString::number(x));
		}

		if (QString::compare(txtPieY->text(), QString::number(y)) == 0) {
			y -= 1;
			txtLandY->setText(QString::number(y));
			txtBarY->setText(QString::number(y));
			txtPieY->setText(QString::number(y));
		}

		if (QString::compare(txtPieZ->text(), QString::number(z)) == 0){
			z += 1;
			txtLandZ->setText(QString::number(z));
			txtBarZ->setText(QString::number(z));
			txtPieZ->setText(QString::number(z));
		}
	}
}

void Window::addLandTitle() {
// add new title to map combobox
	cbLandActAdd->addItem((cbLandAdd->currentText()));
}

void Window::addPieTitle() {
// add new title to pie chart combobox
	cbPieActAdd->addItem((cbPieAdd->currentText()));
}

void Window::removeLandPlane() {
// delets choosen map plane
	int index = cbLandRemove->currentIndex();

	if (index > -1) {
		glWidget->removePlane(GLWidget::PLANE_MAP, index);
		cbLandRemove->removeItem(index);
		//cbLandEdit->removeItem(index);
	}
}

void Window::removeBarPlane() {
// delets choosen bar chart plane

	int index = cbBarRemove->currentIndex();
	if (index > -1) {
		glWidget->removePlane(GLWidget::PLANE_BAR, index);
		cbBarRemove->removeItem(index);
		//cbBarEdit->removeItem(index);
	}
}

void Window::removePiePlane() {
// delets choosen pie chart plane

	int index = cbPieRemove->currentIndex();
	
	if (index > -1) {
		glWidget->removePlane(GLWidget::PLANE_PIE, index);
		cbPieRemove->removeItem(index);
		//cbPieEdit->removeItem(index);
	}
}

void Window::removeItem() {
	switch(glWidget->delType) {
		case 1:	cbLandRemove->removeItem(glWidget->delCol);
					break;
		case 2:	cbBarRemove->removeItem(glWidget->delCol);
					break;
		case 3:	cbPieRemove->removeItem(glWidget->delCol);
					break;
	}
}

void Window::removeSelectedPieElement() {
	int index = cbPieActAdd->currentIndex();
	
	if (index > -1) {
		cbPieActAdd->removeItem(index);
	}
}

void Window::animateMap() {
	int index = cbLandRemove->currentIndex();
	
	if (animate2D == true) {
	// transform to 2D
		if (index > -1) {
			glWidget->to2D(GLWidget::PLANE_MAP, index);
			bAnimateMap->setText("to 3D");
			animate2D = false;
			tabView->setTabEnabled (0, false);
			tabView->setTabEnabled (2, false);
			tabView->setTabEnabled (3, false);
			bMapRemove->setEnabled(false);
			bMapAdd->setEnabled(false);
			cbLandRemove->setEnabled(false);
		}
	}
	else {
	// transform to 3D
		if (index > -1) {
			glWidget->to3D(GLWidget::PLANE_MAP, index);
			bAnimateMap->setText("to 2D");
			animate2D = true;
			tabView->setTabEnabled (0, true);
			tabView->setTabEnabled (2, true);
			tabView->setTabEnabled (3, true);
			bMapRemove->setEnabled(true);
			bMapAdd->setEnabled(true);
			cbLandRemove->setEnabled(true);
		}
	}
}

void Window::animateBar() {
	int index = cbBarRemove->currentIndex();

	if (animate2D == true) {
	// transform to 2D
		if (index > -1) {
			glWidget->to2D(GLWidget::PLANE_BAR, index);
			bAnimateBar->setText("to 3D");
			animate2D = false;
			tabView->setTabEnabled (0, false);
			tabView->setTabEnabled (1, false);
			tabView->setTabEnabled (3, false);
			bBarRemove->setEnabled(false);
			bBarAdd->setEnabled(false);
			cbBarRemove->setEnabled(false);
		}
	}
	else {
	// transform to 3D
		if (index > -1) {
			glWidget->to3D(GLWidget::PLANE_BAR, index);
			bAnimateBar->setText("to 2D");
			animate2D = true;
			tabView->setTabEnabled (0, true);
			tabView->setTabEnabled (1, true);
			tabView->setTabEnabled (3, true);
			bBarRemove->setEnabled(true);
			bBarAdd->setEnabled(true);
			cbBarRemove->setEnabled(true);
		}
	}
}

void Window::animatePie() {
	int index = cbPieRemove->currentIndex();
	
	if (animate2D == true) {
	// transform to 2D
		if (index > -1) {
			glWidget->to2D(GLWidget::PLANE_PIE, index);
			bAnimatePie->setText("to 3D");
			animate2D = false;
			tabView->setTabEnabled (0, false);
			tabView->setTabEnabled (1, false);
			tabView->setTabEnabled (2, false);
			bPieRemove->setEnabled(false);
			bPieAdd->setEnabled(false);
			cbPieRemove->setEnabled(false);
		}
	}
	else {
	// transform to 3D
		if (index > -1) {
			glWidget->to3D(GLWidget::PLANE_PIE, index);
			bAnimatePie->setText("to 2D");
			animate2D = true;
			tabView->setTabEnabled (0, true);
			tabView->setTabEnabled (1, true);
			tabView->setTabEnabled (2, true);
			bPieRemove->setEnabled(true);
			bPieAdd->setEnabled(true);
			cbPieRemove->setEnabled(true);
		}
	}
}

void Window::setVisibility() {

	if (glWidget->updMode == 2) {
	// transform to 2D
		
		animate2D = false;
		tabView->setTabEnabled (0, false);

		if (glWidget->updType == GLWidget::PLANE_MAP) {
			tabView->setCurrentIndex(1);
			tabView->setTabEnabled (2, false);
			tabView->setTabEnabled (3, false);
			bMapRemove->setEnabled(false);
			bMapAdd->setEnabled(false);
			cbLandRemove->setEnabled(false);
			bAnimateMap->setText("to 3D");
		}
		
		if (glWidget->updType == GLWidget::PLANE_BAR) {
			tabView->setCurrentIndex(2);
			tabView->setTabEnabled (3, false);
			tabView->setTabEnabled (1, false);
			bBarRemove->setEnabled(false);
			bBarAdd->setEnabled(false);
			cbBarRemove->setEnabled(false);
			bAnimateBar->setText("to 3D");
		}
		
		if (glWidget->updType == GLWidget::PLANE_PIE) {
			tabView->setCurrentIndex(3);
			tabView->setTabEnabled (2, false);
			tabView->setTabEnabled (1, false);
			bPieRemove->setEnabled(false);
			bPieAdd->setEnabled(false);
			cbPieRemove->setEnabled(false);
			bAnimatePie->setText("to 3D");
		}
	}
	else if (glWidget->updMode == 3){
	// transform to 3D
		if (glWidget->updType == GLWidget::PLANE_MAP) {
			bAnimateMap->setText("to 2D");
		}
		else if (glWidget->updType == GLWidget::PLANE_BAR) {
			bAnimateBar->setText("to 2D");
		}
		else if (glWidget->updType == GLWidget::PLANE_PIE) {
			bAnimatePie->setText("to 2D");
		}
		animate2D = true;
		tabView->setTabEnabled (0, true);
		tabView->setTabEnabled (1, true);
		tabView->setTabEnabled (2, true);
		tabView->setTabEnabled (3, true);
		bMapRemove->setEnabled(true);
		bMapAdd->setEnabled(true);
		cbLandRemove->setEnabled(true);
		bBarRemove->setEnabled(true);
		bBarAdd->setEnabled(true);
		cbBarRemove->setEnabled(true);
		bPieRemove->setEnabled(true);
		bPieAdd->setEnabled(true);
		cbPieRemove->setEnabled(true);
	}	
}