#pragma once

#include "planeBase.h"
#include "Font.h"
#include <time.h>

/**
* Pie chart visualization.
*/
class planePie : public planeBase 
{
private:
	/** renders pie chart visualization */
	void renderVis();

	/** initialize empty plane without data */
	void initPlane();

	/** initialize plane with data 
		 @param cols choosen columns that will be displayed
		 @param dataSet loaded data */
	void initPlane(vector<int> cols, Data& dataSet);

	/** if this plane is selected look if a bar is chosen 
		 @param x x position of the mouse position
		 @param y y position of the mouse position */
	void selectClick(float x, float y);

	/** draws one segment of pie chart
		 @param count how often intermediate steps are done
		 @param startAngle begin of the segment
		 @param endAngle end of the segment*/
	void drawSegment(int count, int startAngle, int endAngle);

	/** draws legend on the left bottom side */
	void drawLegend();

	/** mixes columns for estimating automatic different color
	    @param col1 first value between 0 and 255 that is mixed
		 @param col2 second value between 0 and 255 that is mixed */
	void mixColor(int col1, int col2);

	/** loaded data */
	Data dat;

	/** choosen columns of data for that plane */
	vector<int> col;

	/** calculated color for segment of a pie segment */
	vector<QColor> color;

	/** sum of values of one class */
	vector<float> val;

	/** sum of values of all classes for estimating percentage */
	float total;

	/** handler for window for font */
	HDC hdc;

	/** main window for font */
	HWND hwnd;

	/** font for printing text */
	Font foLegend;
};
