#include "planePie.h"

void planePie::selectClick(float x, float y) {
	selectedPoint=-1;

	float actAngle = 0.0;
	float angle = 0.0;
	float angleY = 0.0;
	float maxX;
	float maxY;
	float PI = 3.14159265;
	float m;

	for (int i=0; i < col.size(); i++) {
		actAngle = actAngle + 360.0 * (val.at(i) / total);
		m = abs(((y - 0.5)*0.25) / ((x - 0.5)*0.33));
		angle = float(atan(m)) * 180.0 / PI;
		
		if (y - 0.5 > 0 && x - 0.5 < 0) 
			angle = 180 - angle;
		else if (y - 0.5 < 0 && x - 0.5 < 0)
			angle = angle + 180;
		else if (y - 0.5 < 0 && x - 0.5 > 0)
			angle = 360 - angle;

		if (angle < actAngle) {
			
			maxX = abs(cos(angle*PI/180)*0.25);
			maxY = abs(sin(angle*PI/180)*0.33);

			if (angle < 90.0 && angle > 0.0) {
				if (0.5 < x && x < 0.5 + maxX && 0.5 < y && y < 0.5 + maxY) {
					selectedPoint = i;
					i = col.size();
				}
			}
			else if (90.0 < angle && angle < 180) {
				if (0.5 - maxX < x && x < 0.5 && 0.5 < y && y < 0.5 + maxY) {
					selectedPoint = i;
					i = col.size();	
				}
			}
			else if(180.0 < angle && angle < 270) {
				if (0.5 - maxX < x && x < 0.5 && 0.5 - maxY < y && y < 0.5) {
					selectedPoint = i;
					i = col.size();	
				}
			}
			else {
				if (0.5 < x && x < 0.5 + maxX && 0.5 - maxY < y && y < 0.5) {
					selectedPoint = i;
					i = col.size();	
				}
			}
		}
	}
}

void planePie::initPlane() {
	Point dataPoint1;
	dataPoint1.x=0.3;
	dataPoint1.y=0.2;
	points.push_back(dataPoint1);

	Point dataPoint2;
	dataPoint2.x=0.3;
	dataPoint2.y=0.2;
	points.push_back(dataPoint2);
}

void planePie::initPlane(vector<int> cols, Data& dataSet) {

	dat = dataSet;
	col = cols;
/*
	float r;
	float g;
	float b;
	
	srand ( time(NULL) );
	for (int i=0; i < col.size(); i++) {
		r = rand() % 255;
		g = rand() % 255;
		b = rand() % 255;
		color.push_back(QColor(r, g, b));
	}
*/
	srand ( time(NULL) );
	int cnt = col.size()/8 + 1;
	float col1;
	float col2;
	
	for (int i=0; i < cnt; i++) {
		col1 = rand() % 255;
		col2 = rand() % 255;

		if (col2 - 20 < col1 && col1 < col2 + 20) {
			if (col1 > 130)
				col2 = col2 - 100;
			else
				col2 = col2 + 100;
		}
		mixColor(col1, col2);

	}

	float newVal;

	for (int i=0; i < col.size(); i++) {
		val.push_back(0.0);
	}

	total = 0.0;
	for (int i=0; i < dat.getSize(); i++) {
		for (int j=0; j < col.size(); j++) {
			newVal = val.at(j) + dat.getValue(i, col.at(j)).valFloat;
			val.erase(val.begin() + j);
			val.insert(val.begin() + j, newVal);
			total += dat.getValue(i, col.at(j)).valFloat;
		}
	}

	hdc = NULL;
	hwnd = NULL;
	hwnd = FindWindow(NULL, "VisLink");
	hdc = GetDC(hwnd);

	foLegend = Font();
	foLegend.createFont(-1, "Arial", hdc, FW_NORMAL);

	float actAngle = 0.0;
	float angle = 0.0;
	Point p;
	float PI = 3.14159265;

	for (int i=0; i < col.size(); i++){
		actAngle = 360 * (val.at(i) / total);
		angle = angle + actAngle/2;
		p.x = 0.5 + (cos(angle*PI/180) * 0.25)/2.0;
		p.y = 0.5 + (sin(angle*PI/180) * 0.33)/2.0;
		points.push_back(p);
		angle = angle + actAngle/2;
	}
}


void planePie::mixColor(int col1, int col2) {
	
	color.push_back(QColor(col1, col1, col1));
	color.push_back(QColor(col1, col1, col2));
	color.push_back(QColor(col1, col2, col1));
	color.push_back(QColor(col1, col2, col2));
	color.push_back(QColor(col2, col1, col1));
	color.push_back(QColor(col2, col1, col2));
	color.push_back(QColor(col2, col2, col1));
	color.push_back(QColor(col2, col2, col2));
}

void planePie::renderVis() {
	float startAngle = 0.0;
	float actAngle = 0.0;
	float endAngle;
	int count = 0;
	
	for (int i=0; i < col.size(); i++) {
		actAngle = 360 * (val.at(i) / total);
		if ( i + 1 == col.size())
			endAngle = 360;
		else
			endAngle = startAngle + actAngle;
		count = actAngle / 2;
		
		if (selectedPoint == i)
			glColor3f(1.0, 1.0, 0.0);
		else
			glColor3f(color.at(i).redF(), color.at(i).greenF(), color.at(i).blueF());

		glBegin(GL_POLYGON);
			drawSegment(count, startAngle, endAngle);
		glEnd();

		glColor3f(0.0, 0.0, 0.0);
		glLineWidth(2.0);
		glBegin(GL_LINE_LOOP);
			drawSegment(count, startAngle, endAngle);
		glEnd();
		startAngle += actAngle;
	}

	drawLegend();

	glColor3f(1.0, 1.0, 1.0);
	for (int i=0; i < col.size(); i++) {
		glPointSize(5);
		glBegin(GL_POINTS);
			glVertex2f((points.at(i)).x, (points.at(i)).y);
		glEnd();
	}
}

void planePie::drawSegment(int count, int startAngle, int endAngle) {
	float x;
	float y;
	float PI = 3.14159265;

	glVertex2f(0.5, 0.5);
	for (int j=0; j <= count; j++) {
		
		x = cos(startAngle*PI/180) * 0.25;
		y = sin(startAngle*PI/180) * 0.33;
		glVertex2f(x + 0.5, y + 0.5);
		if (j < count) {
			startAngle += 2;
		}
		
		if (j == count-1)
			startAngle = endAngle;
	}
	glVertex2f(0.5, 0.5);
}

void planePie::drawLegend() {
	float width = 0.05;
	float height = 0.03;
	float space = 0.01;
	float y = 0.01;
	float x = 0.01;
	vector<QString> title = dat.getTitle();
	char tmp [33];
	QString tmp2;
	float percent;

	for (int i=0; i < col.size(); i++) {

		// plot quader for color legend
		glColor3f(color.at(i).redF(), color.at(i).greenF(), color.at(i).blueF());
		glBegin(GL_QUADS);
			glVertex2f(x, y);
			glVertex2f(x + width, y);
			glVertex2f(x + width, y + height);
			glVertex2f(x, y + height);
		glEnd();

		// plot contour for legend
		glColor3f(0.0, 0.0, 0.0);
		glBegin(GL_LINE_LOOP);
			glVertex2f(x, y);
			glVertex2f(x + width, y);
			glVertex2f(x + width, y + height);
			glVertex2f(x, y + height);
		glEnd();

		// print description for legend
		if (selectedPoint == i)
			glColor3f(1.0, 1.0, 0.0);
		else
			glColor3f(1.0, 1.0, 1.0);	
			
		glPushMatrix();
		glTranslatef(x + width + 0.01, y + 0.01, 0.0);
		glScalef(1.0/40.0, 1.0/35.0, 0);
		tmp2 = title.at(col.at(i)) + ": " + QString::number(val.at(i) / total * 100) + "%";
		strcpy (tmp, tmp2.toLatin1());
		foLegend.printFont(tmp);
		glPopMatrix();

		y += height + space;
	}
}

