#pragma once

#include "planeBase.h"
#include "TargaImage.h"

#include <vector>
using namespace std;

/**
* Map visualization.
*/
class planeMap : public planeBase {
public:
	~planeMap();
private:
	/** renders USA Map visualization */
	void renderVis();

	/** initialize empty plane without data */
	void initPlane();

	/** initialize plane with data 
		 @param cols choosen columns that will be displayed
		 @param dataSet loaded data */
	void initPlane(vector<int> cols, Data& dataSet);

	/** if this plane is selected look if a bar is chosen 
		 @param x x position of the mouse position
		 @param y y position of the mouse position */
	void selectClick(float x, float y);

	/** destroys visualisation */
	void destroyVis();

	GLuint textureMap;

	vector<GLuint> stateTextures;
	vector<TargaImage*> stateTGAs;
};