#include "planeMap.h"

planeMap::~planeMap() {
	glDeleteTextures(1,&textureMap);

	int count=stateTextures.size();
	for (int i=0; i<count; i++) {
		glDeleteTextures(1,&stateTextures[i]);
		delete stateTGAs[i];
	}
	stateTGAs.clear();
	stateTextures.clear();
}

void planeMap::selectClick(float x, float y) {
	selectedPoint=-1;
	for (int i=0; i<stateTGAs.size(); i++) {
		int curX=(int)(x*1024.0-(points[i].x*1024.0-stateTGAs[i]->GetWidth()*0.5)+0.5)-1.0;
		int curY=(int)(y*768.0-(points[i].y*768.0-stateTGAs[i]->GetHeight()*0.5)+0.5)-1.0;
		if (curX>=0 && curX<stateTGAs[i]->GetWidth() &&
			curY>=0 && curY<stateTGAs[i]->GetHeight()) {
				int curAlpha=(int)stateTGAs[i]->GetImage()[(curX+curY*stateTGAs[i]->GetWidth())*4+3];
				if (curAlpha==255) {
					selectedPoint=i;
					break;
				}
		}
	}
}

void planeMap::initPlane(vector<int> cols, Data& dataSet) {
	TargaImage mapTGA;
	mapTGA.Load("map/usa.tga");

	glGenTextures(1, &textureMap);
	glBindTexture(GL_TEXTURE_2D, textureMap);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, mapTGA.GetWidth(), mapTGA.GetHeight(), 0, GL_RGBA, GL_UNSIGNED_BYTE, mapTGA.GetImage());
	mapTGA.Release();

	for (int i=0; i<dataSet.getSize(); i++) {
		string filename="map/";
		filename.append((string)dataSet.getValue(i,cols[0]).valString.toLatin1());
		filename.append(".tga");
		printf("\nload %s", filename.c_str());

		TargaImage *stateTGA=new TargaImage;
		GLuint stateTexture;
		stateTGA->Load(filename);
		glGenTextures(1, &stateTexture);
	
		glBindTexture(GL_TEXTURE_2D, stateTexture);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
		glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, stateTGA->GetWidth(), stateTGA->GetHeight(), 0, GL_RGBA, GL_UNSIGNED_BYTE, stateTGA->GetImage());

		stateTextures.push_back(stateTexture);
		stateTGAs.push_back(stateTGA);

		Point dataPoint;
		dataPoint.x=dataSet.getValue(i,cols[1]).valFloat;
		dataPoint.y=dataSet.getValue(i,cols[2]).valFloat;
		points.push_back(dataPoint);
	}
}

void planeMap::initPlane() {
	TargaImage mapTGA;
	mapTGA.Load("map/usa.tga");

	glGenTextures(1, &textureMap);
	glBindTexture(GL_TEXTURE_2D, textureMap);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, mapTGA.GetWidth(), mapTGA.GetHeight(), 0, GL_RGBA, GL_UNSIGNED_BYTE, mapTGA.GetImage());
	mapTGA.Release();
}

void planeMap::renderVis() {
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, textureMap);
	glBegin(GL_QUADS);
		glTexCoord2f(0.0f, 0.0f);
		glVertex2f(0.0, 0.0);
		glTexCoord2f(1.0f, 0.0f);
		glVertex2f(1.0, 0.0);
		glTexCoord2f(1.0f, 1.0f);
		glVertex2f(1.0, 1.0);
		glTexCoord2f(0.0f, 1.0f);
		glVertex2f(0.0, 1.0);
	glEnd();

	if (selectedPoint!=-1) {
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, stateTextures[selectedPoint]);
		float quadDimX=stateTGAs[selectedPoint]->GetWidth()/1024.0;
		float quadDimY=stateTGAs[selectedPoint]->GetHeight()/768.0;

		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
		glTranslatef(-quadDimX*0.5, -quadDimY*0.5, 0.0);
		glTranslatef(points[selectedPoint].x,points[selectedPoint].y,0.0);

		glBegin(GL_QUADS);
			glTexCoord2f(0.0f, 0.0f);
			glVertex2f(0.0, 0.0);
			glTexCoord2f(1.0f, 0.0f);
			glVertex2f(quadDimX, 0.0);
			glTexCoord2f(1.0f, 1.0f);
			glVertex2f(quadDimX, quadDimY);
			glTexCoord2f(0.0f, 1.0f);
			glVertex2f(0.0, quadDimY);
		glEnd();
	}

	glBindTexture(GL_TEXTURE_2D, 0);
	glDisable(GL_TEXTURE_2D);

	for (int i=0; i<points.size(); i++) {
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();

		glColor3f(1.0,0.0,0.0);
		glPointSize(5);
		glBegin(GL_POINTS);
			glVertex2f(points[i].x, points[i].y);
		glEnd();
	}
}