#pragma once

#include <windows.h>
#include <glew.h>
#include <gl\gl.h>
#include <GL\glut.h>
#include <math.h>

#include "TargaImage.h"

#include <string>
using namespace std;

/**
* Navigator class for different navigator types.
*/
class planeBaseNavigator {
public:
	/** Constructor */
	planeBaseNavigator();

	/** Destructor */
	~planeBaseNavigator();

	/** renders navigator 
		@param dT delta time */
	void render(float dT);

	/** inits navigator 
		@param _needsRenderUpdate pointer to the renderupdate bool of the plane
		@param fileName filename of the image for the navigator 
		@param posX x position of the navigator on the plane
		@param posY y position of the navigator on the plane */
	void init(bool *_needsRenderUpdate, string fileName, int posX, int posY);

	/** sets navigation mode
		@param _navigationMode new mode */
	void setNavigationMode(int _navigationMode);

private:
	/** alpha value of the navigator */
	float alpha;

	/** navigation mode */
	int navigationMode;		// 0... strg nicht gedrckt
							// 1... strg gedrckt
							// 2... strg gedrckt und dieser navigator der aktuelle (mouseover bzw. angeklickt)

	/** the texture of the navigator */
	GLuint texture;

	/** pointer to the renderupdate bool of the plane */
	bool *needsRenderUpdate;

	/** x position of the navigator on the plane */
	float posX;

	/** y position of the navigator on the plane */
	float posY;

	/** width of the navigator */
	float dimX;

	/** height of the navigator */
	float dimY;
};