#include "planeBaseNavigator.h"

planeBaseNavigator::planeBaseNavigator() {
	alpha=0;
	navigationMode=0;
}

planeBaseNavigator::~planeBaseNavigator() {
	glDeleteTextures(1,&texture);
}

void planeBaseNavigator::render(float dT) {

	switch(navigationMode) {
		case 0:
			alpha=0.0;
			break;
		case 1:
			alpha=0.7;
			break;
		case 2:
			alpha=1.0;
			break;
	}

	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, texture);

	glColor4f(1.0,1.0,1.0,alpha);

	glBegin(GL_QUADS);
		glTexCoord2f(0.0f, 0.0f);
		glVertex3f(posX, posY, 0.0);

		glTexCoord2f(1.0f, 0.0f);
		glVertex3f(posX+dimX, posY, 0.0);

		glTexCoord2f(1.0f, 1.0f);
		glVertex3f(posX+dimX, posY+dimY, 0.0);

		glTexCoord2f(0.0f, 1.0f);
		glVertex3f(posX, posY+dimY, 0.0);
	glEnd();
}

void planeBaseNavigator::init(bool *_needsRenderUpdate, string fileName, int _posX, int _posY) {
	needsRenderUpdate=_needsRenderUpdate;

	posX=_posX/1024.0;
	posY=_posY/768.0;

	TargaImage textureTGA;
	textureTGA.Load(fileName);

	dimX=textureTGA.GetWidth()/1024.0;
	dimY=textureTGA.GetHeight()/768.0;

	glGenTextures(1, &texture);
	glBindTexture(GL_TEXTURE_2D, texture);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, textureTGA.GetWidth(), textureTGA.GetHeight(), 0, GL_RGBA, GL_UNSIGNED_BYTE, textureTGA.GetImage());
	textureTGA.Release();
}

void planeBaseNavigator::setNavigationMode(int _navigationMode) {
	if (_navigationMode!=navigationMode) {
		navigationMode=_navigationMode;
		*needsRenderUpdate=true;
	}
}