#include "planeBase.h"
#include "planeAdmin.h"
#include "GLWidget.h"

planeBase::planeBase() {
	fboInitialised=false;
	planeInitialised=false;
	selectedPoint=-1;
	needsRenderUpdate=true;

	parentWidget=NULL;

	deleteMe=false;

	dest2DposX=2.0;
	dest2DposY=1.5;
	dest2DposZ=-2.6;
	dest2DrotX=0.0;
	dest2DrotY=0.0;

	animatingTo2D=false;
	animatingTo3D=false;
	cur2D3Dstate=3;

	navigationMode=0;

	alpha3D=0.7;
	animationSpeed=5.0;//10.0;
	alpha=alpha3D;

	navBook.init(&needsRenderUpdate, "nav/book.tga", 0,0);
	navGarage.init(&needsRenderUpdate, "nav/garage.tga",0,0);
	navDrag.init(&needsRenderUpdate, "nav/drag.tga",384,256);
	navDelete.init(&needsRenderUpdate, "nav/delete.tga",950,700);
	navZoom.init(&needsRenderUpdate, "nav/zoom.tga",890,700);

	createFBO();
}

planeBase::~planeBase() {
	destroyFBO();
}

void planeBase::destroyFBO() {
	glDeleteTextures(1,&fboTexture);
	glDeleteFramebuffersEXT(1, &fbo);
}

void planeBase::createFBO() {
	if (!GLEW_EXT_framebuffer_object) {
		printf("\nFramebuffer Objects nicht verfuegbar");
	} else {
		// Texture
		glGenTextures(1, &fboTexture);
		glBindTexture(GL_TEXTURE_2D, fboTexture);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D, GL_GENERATE_MIPMAP, GL_TRUE);
		glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, 1024, 768, 0, GL_RGBA, GL_UNSIGNED_BYTE, NULL);


		// FBO
		glGenFramebuffersEXT(1, &fbo);
		glBindFramebufferEXT(GL_FRAMEBUFFER_EXT, fbo);
		glFramebufferTexture2DEXT(GL_FRAMEBUFFER_EXT, GL_COLOR_ATTACHMENT0_EXT, GL_TEXTURE_2D, fboTexture,0);

		glBindFramebufferEXT(GL_FRAMEBUFFER_EXT, 0);

		fboInitialised=true;
	}
}

void planeBase::init(vector<int> cols, Data& dataSet, GLWidget *_parentWidget) {
	parentWidget=_parentWidget;
	initPlane(cols, dataSet);
	planeInitialised=true;
}

void planeBase::init() {
	initPlane();
	planeInitialised=true;
}

void planeBase::renderDepth() {
	glColor4f(1.0,0.0,0.0,0.0);

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glTranslatef(posX,posY,posZ);
	glRotatef(rotY,0.0,1.0,0.0);
	glRotatef(rotX,1.0,0.0,0.0);
	glBegin(GL_QUADS);
		glTexCoord2f(0.0f, 0.0f);
		glVertex3f(-4.0, -3.0, 0.0);

		glTexCoord2f(1.0f, 0.0f);
		glVertex3f(0.0, -3.0, 0.0);

		glTexCoord2f(1.0f, 1.0f);
		glVertex3f(0.0, 0.0, 0.0);

		glTexCoord2f(0.0f, 1.0f);
		glVertex3f(-4.0, 0.0, 0.0);
	glEnd();
}

void planeBase::render(float dT) {
	if (fboInitialised && planeInitialised) {

		animate2D3D(dT);

		int view_port[4];
		if (needsRenderUpdate) {
			needsRenderUpdate=false;
			glGetIntegerv( GL_VIEWPORT, view_port );
			glBindFramebufferEXT(GL_FRAMEBUFFER_EXT, fbo);
			glClearColor(0.5,0.5,0.55,1.0);
			glClear(GL_COLOR_BUFFER_BIT);
			glMatrixMode(GL_PROJECTION);
			glPushMatrix();
			glLoadIdentity();
			gluOrtho2D(0.0,1.0,0.0,1.0);
			glViewport(0.0,0.0,1024.0,768.0);
			glMatrixMode(GL_MODELVIEW);
			glLoadIdentity();
			glColor4f(1.0,1.0,1.0,1.0);
			renderVis();
			glMatrixMode(GL_MODELVIEW);
			glLoadIdentity();
			glColor4f(1.0,1.0,1.0,1.0);
			renderNavigators(dT);
			glBindFramebufferEXT(GL_FRAMEBUFFER_EXT, 0);
			glClearColor(1.0,1.0,1.0,1.0);
			glViewport(0.0,0.0,(float)(view_port[2]-view_port[0]),(float)(view_port[3]-view_port[1]));

			glBindTexture(GL_TEXTURE_2D, fboTexture);
			glGenerateMipmapEXT(GL_TEXTURE_2D);
			glBindTexture(GL_TEXTURE_2D, 0);

			glMatrixMode(GL_PROJECTION);
			glPopMatrix();
		}

		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, fboTexture);

		glColor4f(1.0,1.0,1.0,alpha);

/*		glMatrixMode(GL_PROJECTION);
		glPopMatrix();*/
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
		glTranslatef(posX,posY,posZ);
		glRotatef(rotY,0.0,1.0,0.0);
		glRotatef(rotX,1.0,0.0,0.0);
		glBegin(GL_QUADS);
			glTexCoord2f(0.0f, 0.0f);
			glVertex3f(-4.0, -3.0, 0.0);

			glTexCoord2f(1.0f, 0.0f);
			glVertex3f(0.0, -3.0, 0.0);

			glTexCoord2f(1.0f, 1.0f);
			glVertex3f(0.0, 0.0, 0.0);

			glTexCoord2f(0.0f, 1.0f);
			glVertex3f(-4.0, 0.0, 0.0);
		glEnd();

		glBindTexture(GL_TEXTURE_2D, 0);
		glDisable(GL_TEXTURE_2D);
	}
}

void planeBase::renderNavigators(float dT) {
	navBook.render(dT);
	navGarage.render(dT);
	navDrag.render(dT);
	navDelete.render(dT);
	navZoom.render(dT);
}

void planeBase::setPos(float x, float y, float z) {
	posX=x;
	posY=y;
	posZ=z;
}

void planeBase::setRot(float x, float y) {
	rotX=x;
	rotY=y;
}

float planeBase::getDepth() {
	//return posZ;
	return getMiddle().z;
}

bool planeBase::mouseSelectClick(float x, float y) {
	screenToPlane(x,y);

	if (x>=0.0 && x <=1.0 && y>=0.0 && y<=1.0) {
		needsRenderUpdate=true;
		selectClick(x,y);
		return true;
	} else {
		mouseDeselect();
		return false;
	}
}

void planeBase::mouseNavigateDrag(float x, float y) {
	if (navigationMode==0) {
		if (cur2D3Dstate!=2 && !animatingTo2D) {
			navBook.setNavigationMode(1);
			navGarage.setNavigationMode(1);
			navDrag.setNavigationMode(1);
		}
		navZoom.setNavigationMode(1);
		navDelete.setNavigationMode(1);
	}

	float naviMouseDivX=x-naviMousePosX;
	float naviMouseDivY=y-naviMousePosY;

	naviMousePosX=x;
	naviMousePosY=y;

	if (navigationMode==0) {
		screenToPlane(x,y);

		if (x>=0.0 && x <=1.0 && y>=0.0 && y<=1.0) {
			if (x<0.02 && cur2D3Dstate!=2 && !animatingTo2D) {
				navBook.setNavigationMode(2);		// buch
			} else {
				if (y<0.03 && cur2D3Dstate!=2 && !animatingTo2D) {
					navGarage.setNavigationMode(2);	// garagentor
				} else {
					if (x>0.4 && x<0.6 && y>0.4 && y<0.6 && cur2D3Dstate!=2 && !animatingTo2D) {
						navDrag.setNavigationMode(2);	// verschieben
					}
					if (x>0.88 && x<0.92 && y>0.92 && y<0.98) {
						navZoom.setNavigationMode(2);	// zoom
					}
					if (x>0.94 && x<0.98 && y>0.92 && y<0.98) {
						navDelete.setNavigationMode(2);	// Delete
					}
				}
			}
		}
	}

	switch (navigationMode) {
		case 0:
			break;
		case 1:			// buch
			rotY+=naviMouseDivX/2.0;
			rotY=min(90,max(-90,rotY));
			masterPlane->sortTransPlane(type);
			break;
		case 2:			// garagentor
			rotX+=naviMouseDivY/2.0;
			rotX=min(90,max(-90,rotX));
			masterPlane->sortTransPlane(type);
			break;
		case 3:			// verschieben (x, y)
			posX-=naviMouseDivX/670.0*posZ;
			posY+=naviMouseDivY/670.0*posZ;
		//	masterPlane->sortTransPlane(type);
			break;
		case 4:			// verschieben (z)
			posZ+=naviMouseDivY/50.0;
			masterPlane->sortTransPlane(type);
			break;
	}
}

bool planeBase::mouseNavigateClickOn(float x, float y, int button) {
	naviMousePosX=x;
	naviMousePosY=y;

	screenToPlane(x,y);

	if (x>=0.0 && x <=1.0 && y>=0.0 && y<=1.0) {
		if (x<0.02) {
			navigationMode=1;		// buch
		} else {
			if (y<0.03) {
				navigationMode=2;	// garagentor
			} else {
				if (x>0.4 && x<0.6 && y>0.4 && y<0.6) {
					if (button==0) {
						navigationMode=3;	// verschieben (x,y)
					}
					if (button==1) {
						navigationMode=4;	// verschieben (z)
					}
				}
				if (x>0.88 && x<0.92 && y>0.92 && y<0.98) {
					if (cur2D3Dstate==3) {
						navBook.setNavigationMode(0);
						navGarage.setNavigationMode(0);
						navDrag.setNavigationMode(0);
						animateTo2D();	// zoom
					}
					if (cur2D3Dstate==2) {
						navBook.setNavigationMode(1);
						navGarage.setNavigationMode(1);
						navDrag.setNavigationMode(1);
						animateTo3D();
					}
					navZoom.setNavigationMode(1);
					navDelete.setNavigationMode(1);
					needsRenderUpdate=true;
				}
				if (x>0.94 && x<0.98 && y>0.92 && y<0.98) {
					deleteMe=true;	// Delete
				}
			}
		}
		return true;
	} else {
		return false;
	}
}

void planeBase::mouseNavigateClickOff() {
	navigationMode=0;
}

void planeBase::mouseDeselect() {
	if (selectedPoint!=-1) {
		selectedPoint=-1;
		needsRenderUpdate=true;
	}
}

void planeBase::showNavigators() {
	if (cur2D3Dstate!=2 && !animatingTo2D) {
		navBook.setNavigationMode(1);
		navGarage.setNavigationMode(1);
		navDrag.setNavigationMode(1);
	}
	navDelete.setNavigationMode(1);
	navZoom.setNavigationMode(1);

	needsRenderUpdate=true;
}

void planeBase::hideNavigators() {
	navBook.setNavigationMode(0);
	navGarage.setNavigationMode(0);
	navDrag.setNavigationMode(0);
	navDelete.setNavigationMode(0);
	navZoom.setNavigationMode(0);

	needsRenderUpdate=true;
}

int planeBase::getSelectedPoint() {
	return selectedPoint;
}

Point planeBase::getMiddle() {

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glTranslatef(posX,posY,posZ);
	glRotatef(rotY,0.0,1.0,0.0);
	glRotatef(rotX,1.0,0.0,0.0);
	float modelMatrix[16];
	glGetFloatv(GL_MODELVIEW_MATRIX,modelMatrix);

	Point temp;
	temp.x=-2.0;
	temp.y=-1.5;

	temp.z=0;
	Point worldPoint;

	worldPoint.x=temp.x*modelMatrix[0]+temp.y*modelMatrix[4]+temp.z*modelMatrix[8]+modelMatrix[12];
	worldPoint.y=temp.x*modelMatrix[1]+temp.y*modelMatrix[5]+temp.z*modelMatrix[9]+modelMatrix[13];
	worldPoint.z=temp.x*modelMatrix[2]+temp.y*modelMatrix[6]+temp.z*modelMatrix[10]+modelMatrix[14];

	return worldPoint;
}

Point planeBase::getPoint(int _id) {
	if (points.size()-1>=_id) {
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
		glTranslatef(posX,posY,posZ);
		glRotatef(rotY,0.0,1.0,0.0);
		glRotatef(rotX,1.0,0.0,0.0);
		float modelMatrix[16];
		glGetFloatv(GL_MODELVIEW_MATRIX,modelMatrix);

		Point temp=points[_id];
		temp.x=temp.x*4.0-4.0;
		temp.y=temp.y*3.0-3.0;

		temp.z=0;
		Point worldPoint;

		worldPoint.x=temp.x*modelMatrix[0]+temp.y*modelMatrix[4]+temp.z*modelMatrix[8]+modelMatrix[12];
		worldPoint.y=temp.x*modelMatrix[1]+temp.y*modelMatrix[5]+temp.z*modelMatrix[9]+modelMatrix[13];
		worldPoint.z=temp.x*modelMatrix[2]+temp.y*modelMatrix[6]+temp.z*modelMatrix[10]+modelMatrix[14];

		return worldPoint;
	} else {
		printf("\nError: point not found!");
		Point dummyPoint;
		dummyPoint.x=-1.0;
		dummyPoint.y=-1.0;
		dummyPoint.z=-1.0;
		return dummyPoint;
	}
}

void planeBase::animateTo2D() {
	if (cur2D3Dstate==3) {
		last3DposX=posX;
		last3DposY=posY;
		last3DposZ=posZ;
		last3DrotX=rotX;
		last3DrotY=rotY;
	}
	cur2D3Dstate=1;
	animatingTo3D=false;
	animatingTo2D=true;
}

void planeBase::animateTo3D() {
	cur2D3Dstate=1;
	animatingTo3D=true;
	animatingTo2D=false;
}

void planeBase::animate2D3D(float dT) {
	if (animatingTo2D) {
		posX+=(dest2DposX-posX)*dT*animationSpeed;
		posY+=(dest2DposY-posY)*dT*animationSpeed;
		posZ+=(dest2DposZ-posZ)*dT*animationSpeed;
		rotX+=(dest2DrotX-rotX)*dT*animationSpeed;
		rotY+=(dest2DrotY-rotY)*dT*animationSpeed;
		alpha+=(1.0-alpha)*dT*animationSpeed;

		if (((dest2DposX-last3DposX)>0 && (dest2DposX-posX)<0) ||
			((dest2DposY-last3DposY)>0 && (dest2DposY-posY)<0) ||
			((dest2DposZ-last3DposZ)>0 && (dest2DposZ-posZ)<0) ||
			((dest2DrotX-last3DrotX)>0 && (dest2DrotX-rotX)<0) ||
			((dest2DrotY-last3DrotY)>0 && (dest2DrotY-rotY)<0) ||

			((dest2DposX-last3DposX)<0 && (dest2DposX-posX)>0) ||
			((dest2DposY-last3DposY)<0 && (dest2DposY-posY)>0) ||
			((dest2DposZ-last3DposZ)<0 && (dest2DposZ-posZ)>0) ||
			((dest2DrotX-last3DrotX)<0 && (dest2DrotX-rotX)>0) ||
			((dest2DrotY-last3DrotY)<0 && (dest2DrotY-rotY)>0) ||

			(abs(dest2DposX-posX)<0.1 &&
			abs(dest2DposY-posY)<0.1 &&
			abs(dest2DposZ-posZ)<0.1 &&
			abs(dest2DrotX-rotX)<0.1 &&
			abs(dest2DrotY-rotY)<0.1)) {	
							// animation fertig
			posX=dest2DposX;
			posY=dest2DposY;
			posZ=dest2DposZ;
			rotX=dest2DrotX;
			rotY=dest2DrotY;

			alpha=1.0;

			animatingTo2D=false;
			cur2D3Dstate=2;
		}
		masterPlane->sortTransPlane(type);
	}
	if (animatingTo3D) {
		posX+=(last3DposX-posX)*dT*animationSpeed;
		posY+=(last3DposY-posY)*dT*animationSpeed;
		posZ+=(last3DposZ-posZ)*dT*animationSpeed;
		rotX+=(last3DrotX-rotX)*dT*animationSpeed;
		rotY+=(last3DrotY-rotY)*dT*animationSpeed;
		alpha+=(alpha3D-alpha)*dT*animationSpeed;

		if (((last3DposX-dest2DposX)>0 && (last3DposX-posX)<0) ||
			((last3DposY-dest2DposY)>0 && (last3DposY-posY)<0) ||
			((last3DposZ-dest2DposZ)>0 && (last3DposZ-posZ)<0) ||
			((last3DrotX-dest2DrotX)>0 && (last3DrotX-rotX)<0) ||
			((last3DrotY-dest2DrotY)>0 && (last3DrotY-rotY)<0) ||

			((last3DposX-dest2DposX)<0 && (last3DposX-posX)>0) ||
			((last3DposY-dest2DposY)<0 && (last3DposY-posY)>0) ||
			((last3DposZ-dest2DposZ)<0 && (last3DposZ-posZ)>0) ||
			((last3DrotX-dest2DrotX)<0 && (last3DrotX-rotX)>0) ||
			((last3DrotY-dest2DrotY)<0 && (last3DrotY-rotY)>0) ||

			(abs(last3DposX-posX)<0.1 &&
			abs(last3DposY-posY)<0.1 &&
			abs(last3DposZ-posZ)<0.1 &&
			abs(last3DrotX-rotX)<0.1 &&
			abs(last3DrotY-rotY)<0.1)) {	
							// animation fertig
			posX=last3DposX;
			posY=last3DposY;
			posZ=last3DposZ;
			rotX=last3DrotX;
			rotY=last3DrotY;

			alpha=alpha3D;

			animatingTo3D=false;
			cur2D3Dstate=3;
		}
		masterPlane->sortTransPlane(type);
	}
}

void planeBase::screenToPlane(float& x, float& y) {
	// umrechnen von mauskoordinaten auf dem bildschirm zu koordinaten auf dieser plane

	float widgetSizeW=1024.0;
	float widgetSizeH=768.0;

	if (parentWidget!=NULL) {
		widgetSizeW=(float)parentWidget->width;
		widgetSizeH=(float)parentWidget->height;
	}

	float z;
	glReadPixels(x, widgetSizeH-y, 1, 1,GL_DEPTH_COMPONENT,GL_FLOAT, &z);

	x=2.0*x/widgetSizeW-1.0;
	y=1.0-2.0*y/widgetSizeH;
	z=2.0*z-1.0;
	float projMatrix[16];
	glGetFloatv(GL_PROJECTION_MATRIX,projMatrix);

	float tempVec[4];

	tempVec[3]=z/projMatrix[14]+(-projMatrix[10]/(projMatrix[14]*projMatrix[11]));

	tempVec[0]=x/projMatrix[0]/tempVec[3];
	tempVec[1]=y/projMatrix[5]/tempVec[3];
	tempVec[2]=1.0/projMatrix[11]/tempVec[3];

	float invModelviewMatrix[16];

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glRotatef(-rotX,1.0,0.0,0.0);
	glRotatef(-rotY,0.0,1.0,0.0);
	glTranslatef(-posX,-posY,-posZ);
	glGetFloatv(GL_MODELVIEW_MATRIX,invModelviewMatrix);

	x=tempVec[0]*invModelviewMatrix[0]+tempVec[1]*invModelviewMatrix[4]+tempVec[2]*invModelviewMatrix[8]+invModelviewMatrix[12];
	y=tempVec[0]*invModelviewMatrix[1]+tempVec[1]*invModelviewMatrix[5]+tempVec[2]*invModelviewMatrix[9]+invModelviewMatrix[13];
	z=tempVec[0]*invModelviewMatrix[2]+tempVec[1]*invModelviewMatrix[6]+tempVec[2]*invModelviewMatrix[10]+invModelviewMatrix[14];

	x=1.0+x/4.0;
	y=1.0+y/3.0;

//	printf("\nklick at: %f, %f, %f", x, y, z);

	if (abs(z) >0.05) {
		x=-1.0;
		y=-1.0;
	}
}

int planeBase::getCur2D3Dstate() {
	return cur2D3Dstate;
}