#pragma once

#include "planeBase.h"
#include "Font.h"
#include <Qt\QString.h>
#include <QtOpenGL\QtOpenGL>

/**
* Bar chart visualization.
*/
class planeBar : public planeBase 
{
private:
	/** renders bar chart visualization */
	void renderVis();

	/** initialize empty plane without data */
	void initPlane();

	/** initialize plane with data 
		 @param cols choosen columns that will be displayed
		 @param dataSet loaded data */
	void initPlane(vector<int> cols, Data& dataSet);

	/** if this plane is selected look if a bar is chosen 
		 @param x x position of the mouse position
		 @param y y position of the mouse position */
	void selectClick(float x, float y);

	/** draws background line on 100%, 75%, 50% and 25% 
	    @param y y position of the line
		 @param mode if 100, 75, 50 or 25 should be displayed */
	void drawLine(float y, int mode);

	/** prints labels by the help of font for describtion of states
		 @param x x position of the label
		 @param y y position of the label
		 @param label string of printed label */
	void printLabels(float x, float y, QString label);

	/** loaded data */
	Data dat;

	/** choosen columns of data for that plane */
	vector<int> col;

	/** if base is 100 oder smaller for printing the percentage on the left side */
	float base; 

	/** handler for window for font */
	HDC hdc;

	/** main window for font */
	HWND hwnd;

	/** font for printing text */
	Font foName;

	/** widht of each bar */
	float barWidth;

	/** height of each bar */
	float barHeight;

	/** space between bars */
	float barMargin;

	/** x position where first bar starts */
	float startX;

	/** y position where all bars start */
	float startY;

};
