#include "planeBar.h"

void planeBar::selectClick(float x, float y) {

	selectedPoint=-1;

	for (int i=0; i < dat.getSize(); i++) {
		if (points.at(i).x - barWidth/2.0 <= x && x < points.at(i).x + barWidth/2.0 && startY <= y && y < ((points.at(i).y-startY)*2.0)+startY) {
			selectedPoint = i;
			i = dat.getSize();
		}
	}
}

void planeBar::initPlane() {
	Point dataPoint1;
	dataPoint1.x=0.3;
	dataPoint1.y=0.2;
	points.push_back(dataPoint1);

	Point dataPoint2;
	dataPoint2.x=0.3;
	dataPoint2.y=0.2;
	points.push_back(dataPoint2);
}

void planeBar::initPlane(vector<int> cols, Data& dataSet) {

	dat = dataSet;
	col = cols;
	col.at(0) = col.at(0) + 1;

	// init how many bars should be displayed and their size
	barMargin = 0.005;
	barWidth = (0.90 - dat.getSize() * barMargin) / dat.getSize();
	barHeight = 0.83;
	startX = 0.05;
	startY = 0.12;

	hdc = NULL;
	hwnd = NULL;
	hwnd = FindWindow(NULL, "VisLink");
	hdc = GetDC(hwnd);

	foName = Font();
	foName.createFont(-1, "Arial", hdc, FW_NORMAL);


	Point p;
	p.x = 0.0;
	p.y = startY;
	dataInfo info;
	
	info = dat.getValue(1, col.at(1));
	if (info.type == Data::TYPE_PERCENT)
		base = 100.0;
	else {
		base = 0.0;
		for (int i=0; i < dat.getSize(); i++) {
			info = dat.getValue(i, col.at(1));
			if (info.valFloat > base)
				base = (float)info.valFloat;
		}
	}

	for (int i=0; i < dat.getSize(); i++) {
		info = dat.getValue(i, col.at(1));
		p.y = startY + barHeight * (info.valFloat / base) / 2.0;
		if (i == 0)
			p.x = startX + barWidth/2.0;
		else
			p.x = p.x + barWidth + barMargin;
		points.push_back(p);
	}


}


void planeBar::renderVis() {
// renders plane for bar chart

	float x = startX;
	double y = 0.0;	
	dataInfo info;
	float top = 0.95 - startY;

	drawLine(top/2+startY, 1);
	drawLine(0.95, 2);
	drawLine(top/4+startY, 3);
	drawLine(top-top/4+startY, 4);


	for (int i=0; i < dat.getSize(); i++) {
		// get value from actual line with the correct column
		info = dat.getValue(i, col.at(1));

		// check if type is a float and estimate bar height
		if (info.type == Data::TYPE_FLOAT || info.type == Data::TYPE_PERCENT) {
			printLabels(x, i%2, dat.getValue(i, col.at(0)).valString);
			y = barHeight * (info.valFloat / base);
			
			if (i == selectedPoint)
				glColor3f(1.0, 1.0, 0.0);
			else
				glColor3f(0.0, 1.0, 0.0);
	
			glBegin(GL_QUADS);
				glVertex2f(x, startY);
				glVertex2f(x + barWidth, startY);
				glVertex2f(x + barWidth, startY + y);
				glVertex2f(x, startY + y);
			glEnd();
			x = x + barWidth + barMargin;
		}
	}



	glColor3f(1.0, 1.0, 1.0);
	for (int i=0; i < dat.getSize(); i++) {
		glPointSize(5);
		glBegin(GL_POINTS);
			glVertex2f((points.at(i)).x, (points.at(i)).y);
		glEnd();
	}
}

void planeBar::printLabels(float x, float y, QString label) {
	char buffer[33];

	glColor3f(1.0, 1.0, 1.0);
	glPushMatrix();
	if (y == 1)
		glTranslatef(x, 0.1, 0.0);
	else
		glTranslatef(x, 0.08, 0.0);
	glScalef(1.0/53.0, 1.0/48.0, 0);
	strcpy (buffer, label.toLatin1());
	foName.printFont(buffer);
	glPopMatrix();
}

void planeBar::drawLine(float y, int mode) {
	char buffer[33];
	QString tmp;

	glColor3f(1.0, 1.0, 1.0);
	glPushMatrix();
	glTranslatef(0.0, y, 0.0);
	//glRotatef(90, 1.0, 1.0, 0.0);
	glScalef(1.0/38.0, 1.0/38.0, 0);
	if (base == 100.0) {
		switch(mode) {
			case 1: 	tmp = "50%";
						break;
			case 2:  tmp = "100%";
						break;
			case 3:  tmp = "25%";
						break;
			case 4:  tmp = "75%";
						break;
		}
		strcpy (buffer, tmp.toLatin1());
	}
	else {
		switch(mode) {
			case 1: 	itoa(base/2.0, buffer, 10);
						break;
			case 2: itoa(base, buffer, 10);
						break;
			case 3: itoa(base/4.0, buffer, 10);
						break;
			case 4: itoa(base - base/4.0, buffer, 10);
						break;
		}
		
	}
	foName.printFont(buffer);

	glPopMatrix();
	
	glColor3f(1.0, 1.0, 1.0);
	glBegin(GL_LINE_LOOP);
		glVertex2f(0.0, y);
		glVertex2f(1.0, y);
	glEnd();
}