#pragma once

#include <vector>
#include "planeMap.h"
#include "planeBar.h"
#include "planePie.h"
#include "Data.h"
#include "window.h"
#include "links.h"
#include "GlWidget.h"

typedef struct {
	int column;
	int type;
} sortData;

/**
* Manager for the planes.
*/
class planeAdmin {

private:
	/** sorts the planes by depth when a new plane gots added
		@param type type of the new plane */
	void sortNewPlane(int type);

	/** sorts the planes by depth when a plane gots deleted
		@param type type of the plane to delete
		@param index index of plane to delete */
	void sortDelPlane(int type, int index);

	/** links between planes */
	links planeLinks;

	/** the parent widget */
	GLWidget *parent;


public:
	/** true if the 2D/3D mode changes */
	bool act2DModeChanged;

	/** type of the changing plane */
	int act2DModeType;

	/** current 2D/3D mode */
	int act2DMode;

	/** next 2D/3D mode */
	int next2DMode;

	/** index of the changing plane */
	int act2DIndex;

	/** Constructor */
	planeAdmin();

	/** Destructor */
	~planeAdmin(void);

	/** adds a new plane
		@param type type of the new plane
		@param data the dataset
		@param choosen columns for the plane
		@param x x position of the plane
		@param y y position of the plane
		@param z z position of the plane
		@param rotX orientation around the x-axis
		@param rotY orientation around the z-axis */
	void addPlane(int type, Data *data, vector<int> col, int x, int y, int z, int rotX, int rotY);

	/** sets the parent widget
		@param _parent widget */
	void setParent(GLWidget *_parent);

	/** deletes a plane
		@param type type of the plane to delete
		@param index index of the plane to delete */
	void deletePlane(int type, int index);

	/** renderes all current planes and links
		@param dT delta time */
	void renderAll(float dT);

	/** sorts the planes by depth when a plane gots transformed
		@param type type of the transformed plane */
	void sortTransPlane(int type);

	/** mouseclick
		@param x x position of the mouse cursor
		@param y y position of the mouse cursor */
	void picking(float x, float y);

	/** mouseclick in navigation mode
		@param x x position of the mouse cursor
		@param y y position of the mouse cursor
		@param button index of the mouse button */
	void navigate(float x, float y, int button=0);

	/** release of the mouse button in navigation mode*/
	void navigateRelease();

	/** mouse moved
		@param x x position of the mouse cursor
		@param y y position of the mouse cursor */
	void mouseMove(float x, float y);

	/** shows the navigators */
	void showNavigators();

	/** hides the navigators */
	void hideNavigators();

	/** animate plane to 2D view
		@param type type of plane to animate
		@param index index of plane to animate */
	void to2D(int type, int index);

	/** animate plane to 3D view
		@param type type of plane to animate
		@param index index of plane to animate */
	void to3D(int type, int index);

	/** GUI needs to be updated */
	bool bupdateGUI;

	/** map type */
	static const int PLANE_MAP = 1;

	/** bar type */
	static const int PLANE_BAR = 2;

	/** pie type */
	static const int PLANE_PIE = 3;

	/** sorted planes */
	vector<sortData> sorted;

	/** all map planes */
	vector<planeMap*> pMap;

	/** all bar planes */
	vector<planeBar*> pBar;

	/** all pie planes */
	vector<planePie*> pPie;

	/** type and index of plane to delete */
	sortData delInfo;
};
