#include "planeAdmin.h"

planeAdmin::planeAdmin()  {
	bupdateGUI = false;
	act2DModeChanged = false;
	act2DMode = 3;
	planeLinks.masterPlane=this;
}

planeAdmin::~planeAdmin(void)
{
}

void planeAdmin::setParent(GLWidget *_parent) {
	parent=_parent;
}

void planeAdmin::addPlane(int type, Data *dat, vector<int> col, int x, int y, int z, int rotX, int rotY) {

	planeMap *map; 
	planeBar *bar;
	planePie *pie;

	vector<int> colForLinks;

	switch(type) {
		case 1:  map = new planeMap();
					map->init(col, *dat, parent);
					map->setPos(x, y, z);
					map->setRot(rotX, rotY);
					map->type=1;
					map->masterPlane=this;
					pMap.push_back(map);
					colForLinks.push_back(col[0]);
					planeLinks.addPlane(colForLinks,*dat,*map,1);
					break;

		case 2:	bar = new planeBar();
					bar->init(col, *dat, parent);
					bar->setPos(x, y, z);
					bar->setRot(rotX, rotY);
					bar->type=2;
					bar->masterPlane=this;
					pBar.push_back(bar);
					colForLinks.push_back(col[0]);
					planeLinks.addPlane(colForLinks,*dat,*bar,2);
					break;

		case 3:	pie = new planePie();
					pie->init(col, *dat, parent);
					pie->setPos(x, y, z);
					pie->setRot(rotX, rotY);
					pie->type=3;
					pie->masterPlane=this;
					pPie.push_back(pie);
					for (int i=0; i<col.size(); i++) {
						colForLinks.push_back(col[i]);
					}
					planeLinks.addPlane(colForLinks,*dat,*pie,3);
					break;
	}
	sortNewPlane(type);
}

void planeAdmin::deletePlane(int type, int index){

	switch(type) {
		case 1:  
			planeLinks.removePlane(*(pMap[index]));
			pMap.erase(pMap.begin() + index);
					break;
		case 2:
			planeLinks.removePlane(*(pBar[index]));
			pBar.erase(pBar.begin() + index);
					break;
		case 3:
			planeLinks.removePlane(*(pPie[index]));
			pPie.erase(pPie.begin() + index);
					break;
	}
	
	sortDelPlane(type, index);
}

void planeAdmin::renderAll(float dT){
	// may delete a plane
	for (int i=0; i < pMap.size(); i++) {
		if ((pMap.at(i))->deleteMe) {
			deletePlane(1,i);
			bupdateGUI = true;
			delInfo.type = 1;
			delInfo.column = i;
		}
	}

	for (int i=0; i < pBar.size(); i++) {
		if ((pBar.at(i))->deleteMe) {
			deletePlane(2,i);
			bupdateGUI = true;
			delInfo.type = 2;
			delInfo.column = i;
		}
	}

	for (int i=0; i < pPie.size(); i++) {
		if ((pPie.at(i))->deleteMe) {
			deletePlane(3,i);
			bupdateGUI = true;
			delInfo.type = 3;
			delInfo.column = i;
		}
	}

	sortData sd;

	planeLinks.render();	
	glDepthMask(false);

	int act2DsortedIndex=-1;

	//for (int i=sorted.size()-1; i >=0; i--) {
	for (int i=0; i<sorted.size(); i++) {
		sd = sorted.at(i);

		planeBase *firstPlane=NULL;
		planeBase *secondPlane=NULL;

		switch(sd.type) {
			case PLANE_MAP:	
									firstPlane=pMap.at(sd.column);

									if (pMap.at(sd.column)->getCur2D3Dstate()==2 || (next2DMode==2 && pMap.at(sd.column)->getCur2D3Dstate()==1)) {
										act2DsortedIndex=i;
									} else {
										pMap.at(sd.column)->render(dT);
									}

									if ((act2DMode == 3 && pMap.at(sd.column)->getCur2D3Dstate() == 1) ||
										 (act2DMode == 2 && pMap.at(sd.column)->getCur2D3Dstate() == 1)) {
										// update GUI because 2D or 3D view has changed
										act2DModeChanged = true;
										act2DModeType = PLANE_MAP;
										act2DIndex = sd.column;
										if (act2DMode == 3)
											next2DMode = 2;
										else
											next2DMode = 3;
										act2DMode = 1;
									}


									break;
			case PLANE_BAR:	
									firstPlane=pBar.at(sd.column);
									if (pBar.at(sd.column)->getCur2D3Dstate()==2 || (next2DMode==2 && pBar.at(sd.column)->getCur2D3Dstate()==1)) {
										act2DsortedIndex=i;
									} else {
										pBar.at(sd.column)->render(dT);
									}


									if ((act2DMode == 3 && pBar.at(sd.column)->getCur2D3Dstate() == 1) ||
										 (act2DMode == 2 && pBar.at(sd.column)->getCur2D3Dstate() == 1)) {
										// update GUI because 2D or 3D view has changed
										act2DModeChanged = true;
										act2DModeType = PLANE_BAR;
										act2DIndex = sd.column;
										act2DsortedIndex=i;
										if (act2DMode == 3)
											next2DMode = 2;
										else
											next2DMode = 3;
										act2DMode = 1;
									}
									break;
			case PLANE_PIE:	
									firstPlane=pPie.at(sd.column);
									if (pPie.at(sd.column)->getCur2D3Dstate()==2 || (next2DMode==2 && pPie.at(sd.column)->getCur2D3Dstate()==1)) {
										act2DsortedIndex=i;
									} else {
										pPie.at(sd.column)->render(dT);
									}
									
									if ((act2DMode == 3 && pPie.at(sd.column)->getCur2D3Dstate() == 1) ||
										 (act2DMode == 2 && pPie.at(sd.column)->getCur2D3Dstate() == 1)) {
										// update GUI because 2D or 3D view has changed
										act2DModeChanged = true;
										act2DModeType = PLANE_PIE;
										act2DIndex = sd.column;
										act2DsortedIndex=i;
										if (act2DMode == 3)
											next2DMode = 2;
										else
											next2DMode = 3;
										act2DMode = 1;
									}
									break;
		}

		// check if mode changed to 2D or 3D -> set correct index
		switch(act2DModeType) {
			case PLANE_MAP:	if (act2DMode == 1 && pMap.at(sd.column)->getCur2D3Dstate() != 1) {
										if (act2DIndex == sd.column)
											act2DMode = pMap.at(sd.column)->getCur2D3Dstate();
									}
									break;
			case PLANE_BAR:	if (act2DMode == 1 && pBar.at(sd.column)->getCur2D3Dstate() != 1) {
										if (act2DIndex == sd.column)
											act2DMode = pBar.at(sd.column)->getCur2D3Dstate();
									}
									break;
			case PLANE_PIE:	if (act2DMode == 1 && pPie.at(sd.column)->getCur2D3Dstate() != 1) {
										if (act2DIndex == sd.column)
											act2DMode = pPie.at(sd.column)->getCur2D3Dstate();
									}
									break;
		}
	}

	if (act2DsortedIndex!=-1) {
		glDisable(GL_DEPTH_TEST);
		sd = sorted.at(act2DsortedIndex);

		switch(sd.type) {
			case PLANE_MAP:	pMap.at(sd.column)->render(dT);
									break;
			case PLANE_BAR:	pBar.at(sd.column)->render(dT);
									break;
			case PLANE_PIE:	pPie.at(sd.column)->render(dT);
									break;
		}
	}
	
	glEnable(GL_DEPTH_TEST);

	glDepthMask(true);
	glClear(GL_DEPTH_BUFFER_BIT);
	for (int i=0; i<sorted.size(); i++) {
		sd = sorted.at(i);

		switch(sd.type) {
			case PLANE_MAP:	pMap.at(sd.column)->renderDepth();
									break;
			case PLANE_BAR:	pBar.at(sd.column)->renderDepth();
									break;
			case PLANE_PIE:	pPie.at(sd.column)->renderDepth();
									break;
		}
	}
}

void planeAdmin::sortNewPlane(int type){
	sortData sd;
	float nextZ;
	float actZ;
	bool atEnd;
	int addedCol;

	if (sorted.size() == 0) {
	// add first plane -> nothing to sort
		sd.column = 0;
		sd.type = type;
		sorted.push_back(sd);
	}
	else {
	// sort planes
		
		atEnd = true;
		// get back last index from added plane
		switch(type) {
			case PLANE_MAP:	addedCol = pMap.size()-1;
									actZ = (pMap.at(addedCol))->getDepth();
									break;
			case PLANE_BAR:	addedCol = pBar.size()-1;
									actZ = (pBar.at(addedCol))->getDepth();
									break;
			case PLANE_PIE:	addedCol = pPie.size()-1;
									actZ = (pPie.at(addedCol))->getDepth();
									break;
		}
		
		for (int j=0; j < sorted.size(); j++) {
			if (addedCol == j && sorted.at(j).type == type) {
			}
			else {
				
				// estimate actual z value
				switch(sorted.at(j).type) {
					case PLANE_MAP:	nextZ = (pMap.at(sorted.at(j).column))->getDepth();
											break;
					case PLANE_BAR:	nextZ = (pBar.at(sorted.at(j).column))->getDepth();
											break;
					case PLANE_PIE:	nextZ = (pPie.at(sorted.at(j).column))->getDepth();
											break;
				}

		//		cout << actZ << " " << nextZ << " " << sorted.at(j).type << endl;
				if (actZ < nextZ) {
				// new plane is nearer than actual plane -> put the column in sorted
					sd.column = addedCol;
					sd.type = type;
					sorted.insert(sorted.begin()+j, sd);
					atEnd = false;
					break;
				}
			}
		}

		// if the added plane is the farest away -> add it at the end
		if (atEnd == true) {
			sd.column = addedCol;
			sd.type = type;
			sorted.push_back(sd);
		}
	}
/*
	for (int i=0; i < sorted.size(); i++) {
		cout << "column: " << sorted.at(i).column << " type: " << sorted.at(i).type << endl;
	}
	*/
}

void planeAdmin::sortDelPlane(int type, int index) {
	sortData sd;
	bool newIndex = false;

	if (sorted.size() == 1) {
		sorted.erase(sorted.begin());
	}
	else {
		for (int i=0; i < sorted.size(); i++) {
			sd = sorted.at(i);
			if (index == sd.column && type == sd.type) {
			// deleted index found -> remove that index
				sorted.erase(sorted.begin()+i);
				break;
			}
		}
		for (int i=0; i < sorted.size(); i++) {
			sd = sorted.at(i);
			if ((type == PLANE_PIE && pPie.size() > 0) || (type == PLANE_BAR && pBar.size() > 0) || (type == PLANE_MAP && pMap.size() > 0)) {
				if (type == sd.type && sd.column > index) {
				// if an index exist that is bigger than the deleted index -> set this index-1
					if (sorted.at(i).column > 0) {
						sorted.at(i).column = sorted.at(i).column - 1;
					}
				}
			}
		}
	}
}

void planeAdmin::sortTransPlane(int type) {
	 sortData sd;
	 float actZ = 0.0;
	 float nextZ = 0.0;
	 bool bInsert = false;
/*
	 cout << "start: ------------------------------ " << sorted.size() << endl;
	 	for (int i=0; i < sorted.size(); i++) {
			cout << "column: " << sorted.at(i).column << " type: " << sorted.at(i).type << endl;
		}*/
	 // find index if there exist one that is wrong sorted
	 for (int i=0; i < sorted.size()-1; i++) {
		  switch(sorted.at(i).type) {
				case PLANE_MAP: actZ = (pMap.at(sorted.at(i).column))->getDepth();
						break;
				case PLANE_BAR: actZ = (pBar.at(sorted.at(i).column))->getDepth();
						break;
				case PLANE_PIE: actZ = (pPie.at(sorted.at(i).column))->getDepth();
						break;
		  }

		  switch(sorted.at(i+1).type) {
				case PLANE_MAP: nextZ = (pMap.at(sorted.at(i+1).column))->getDepth();
						break;
				case PLANE_BAR: nextZ = (pBar.at(sorted.at(i+1).column))->getDepth();
						break;
				case PLANE_PIE: nextZ = (pPie.at(sorted.at(i+1).column))->getDepth();
						break;
		  }
		  
		  if (actZ > nextZ) { 
				sd = sorted.at(i+1);
				sorted.erase(sorted.begin()+i+1);
				actZ = nextZ;
				bInsert = true;
				break;
		  }
	 }

	 if (bInsert == true) {
		  // insert index at correct position
		
		  for (int i=0; i < sorted.size(); i++) {
				switch(sorted.at(i).type) {
				 case PLANE_MAP: nextZ = (pMap.at(sorted.at(i).column))->getDepth();
						 break;
				 case PLANE_BAR: nextZ = (pBar.at(sorted.at(i).column))->getDepth();
						 break;
				 case PLANE_PIE: nextZ = (pPie.at(sorted.at(i).column))->getDepth();
						 break;
				}

 				if (actZ < nextZ) {
					sorted.insert(sorted.begin()+i, sd);
					break;
				}
		  }
	 }

//cout << "ende: ------------------------------ " << endl;
	 	for (int i=0; i < sorted.size(); i++) {
//		cout << "column: " << sorted.at(i).column << " type: " << sorted.at(i).type << endl;
	}
}


void planeAdmin::picking(float x, float y){
//	cout << "x: " << x << "y: " << y << endl;
	bool stop=false;

	for (int j=0; j < sorted.size(); j++) {	
		switch(sorted.at(j).type) {
			case PLANE_MAP:
				if (stop==false)
					stop = (pMap.at(sorted.at(j).column))->mouseSelectClick(x, y);
				else
					(pMap.at(sorted.at(j).column))->mouseDeselect();
				break;
			case PLANE_BAR:
				if (stop==false)
					stop = (pBar.at(sorted.at(j).column))->mouseSelectClick(x, y);
				else
					(pBar.at(sorted.at(j).column))->mouseDeselect();
				break;
			case PLANE_PIE:
				if (stop==false)
					stop = (pPie.at(sorted.at(j).column))->mouseSelectClick(x, y);
				else
					(pPie.at(sorted.at(j).column))->mouseDeselect();
				break;
		}
	}

	/*for (int i=0; i < pMap.size(); i++) {
		if (stop == false)
			stop = (pMap.at(i))->mouseSelectClick(x, y);
		else
			(pMap.at(i))->mouseDeselect();
	}

	for (int i=0; i < pBar.size(); i++) {
		if (stop == false)
			stop = (pBar.at(i))->mouseSelectClick(x, y);
		else
			(pBar.at(i))->mouseDeselect();
	}

	for (int i=0; i < pPie.size(); i++) {
		if (stop == false)
			stop = (pPie.at(i))->mouseSelectClick(x, y);
		else
			(pPie.at(i))->mouseDeselect();
	}*/
}

void planeAdmin::navigate(float x, float y, int button){
	bool stop=false;

	for (int j=0; j < sorted.size(); j++) {	
		switch(sorted.at(j).type) {
			case PLANE_MAP:
				if (stop==false)
					stop = (pMap.at(sorted.at(j).column))->mouseNavigateClickOn(x, y, button);
				break;
			case PLANE_BAR:
				if (stop==false)
					stop = (pBar.at(sorted.at(j).column))->mouseNavigateClickOn(x, y, button);
				break;
			case PLANE_PIE:
				if (stop==false)
					stop = (pPie.at(sorted.at(j).column))->mouseNavigateClickOn(x, y, button);
				break;
		}
	}

	/*for (int i=0; i < pMap.size(); i++) {
		if (stop == false)
			stop = (pMap.at(i))->mouseNavigateClickOn(x, y, button);
		else
			break;
	}

	for (int i=0; i < pBar.size(); i++) {
		if (stop == false)
			stop = (pBar.at(i))->mouseNavigateClickOn(x, y, button);
		else
			break;
	}

	for (int i=0; i < pPie.size(); i++) {
		if (stop == false)
			stop = (pPie.at(i))->mouseNavigateClickOn(x, y, button);
		else
			break;
	}*/
}

void planeAdmin::navigateRelease(){
	for (int i=0; i < pMap.size(); i++) {
		(pMap.at(i))->mouseNavigateClickOff();
	}

	for (int i=0; i < pBar.size(); i++) {
		(pBar.at(i))->mouseNavigateClickOff();
	}

	for (int i=0; i < pPie.size(); i++) {
		(pPie.at(i))->mouseNavigateClickOff();
	}
}

void planeAdmin::showNavigators() {
	for (int i=0; i < pMap.size(); i++) {
		(pMap.at(i))->showNavigators();
	}

	for (int i=0; i < pBar.size(); i++) {
		(pBar.at(i))->showNavigators();
	}

	for (int i=0; i < pPie.size(); i++) {
		(pPie.at(i))->showNavigators();
	}
}

void planeAdmin::hideNavigators() {
	for (int i=0; i < pMap.size(); i++) {
		(pMap.at(i))->hideNavigators();
	}

	for (int i=0; i < pBar.size(); i++) {
		(pBar.at(i))->hideNavigators();
	}

	for (int i=0; i < pPie.size(); i++) {
		(pPie.at(i))->hideNavigators();
	}
}

void planeAdmin::mouseMove(float x, float y){
	for (int i=0; i < pMap.size(); i++) {
		(pMap.at(i))->mouseNavigateDrag(x, y);
	}

	for (int i=0; i < pBar.size(); i++) {
		(pBar.at(i))->mouseNavigateDrag(x, y);
	}

	for (int i=0; i < pPie.size(); i++) {
		(pPie.at(i))->mouseNavigateDrag(x, y);
	}
}

void planeAdmin::to2D(int type, int index) {
	switch(type) {
		case PLANE_MAP: (pMap.at(index))->animateTo2D();
							 break;
		case PLANE_BAR: (pBar.at(index))->animateTo2D();
							 break;
		case PLANE_PIE: (pPie.at(index))->animateTo2D();
							 break;
	}
}

void planeAdmin::to3D(int type, int index) {
	switch(type) {
		case PLANE_MAP: (pMap.at(index))->animateTo3D();
							 break;
		case PLANE_BAR: (pBar.at(index))->animateTo3D();
							 break;
		case PLANE_PIE: (pPie.at(index))->animateTo3D();
							 break;
	}
}