#pragma once

#include <vector>
#include <utility>
using namespace std;

#include "planeBase.h"
//#include "planeAdmin.h"

class planeAdmin;

struct planePoints {
	planeBase *plane;
	vector<pair<int, int>> rowsPoints;
};

typedef pair<int, int> link;

/**
* Manager for the links between planes.
*/
class links {
public:
	/** adds a new plane to the Linkmanager
		@param cols choosen columns of the plane
		@param dataset the loaded dataset
		@param plane the new plane
		@param type the type of the plane */
	void addPlane(vector<int> cols, Data& dataSet, planeBase& plane,int type);

	/** removes a plane from the Linkmanager
		@param plane the plane to remove */
	void removePlane(planeBase& plane);

	/** renders the links */
	void render();

	/** pointer to the planeAdmin which stores all planes */
	planeAdmin *masterPlane;

private:
	/** sorts the planes so the nearest planes get linked */
	void orderPlanes();

	/** finds the source node (if a node is selected) an re-orders the planes accordingly*/
	void findSource();

	/** returns the plane index of the outermost plane */ 
	int findOrderStart();

	/** the sourcenode (plane + node of the plane) */
	pair<int, int> source;

	/** number of rows in the dataset */
	int rowCount;

	/** returns a vector of link pairs for two planes
		@param firstPlane first plane
		@param secondPlane second plane
		@return a vector of link-pairs*/
	vector<link> getLinks(planeBase& firstPlane, planeBase& secondPlane);

	/** planes and their points */
	vector<planePoints> planes;

	/** ordered planes */
	vector<planeBase*> orderedPlanes;

	/** vector of points for spline calculation */
	vector<Point> splineStart;

	/** vector of points for spline calculation */
	vector<Point> splineAfter;

	/** calculates the spline between two points */
	void calcSpline(int index1, int index2);
};