#include "links.h"
#include "planeAdmin.h"

void links::addPlane(std::vector<int> cols, Data &dataSet, planeBase &plane, int type) {
	planePoints pP;

	pP.plane=&plane;

	rowCount=dataSet.getSize();

	if (type==1 || type==2)	{	// e.g. bar, map
		for (int i=0; i<dataSet.getSize(); i++) {
			pP.rowsPoints.push_back(pair<int, int>(i,i));
		}
	}

	if (type==3) {	// e.g. pie
		for (int i=0; i<dataSet.getSize(); i++) {
			float maxValue=0.0;
			int maxIndex=0;
			for (int j=0; j<cols.size(); j++) {
				if (dataSet.getValue(i,cols[j]).valFloat>maxValue) {
					maxValue=dataSet.getValue(i,cols[j]).valFloat;
					maxIndex=j;
				}
			}
			pP.rowsPoints.push_back(pair<int, int>(i,maxIndex));
		}
	}

	planes.push_back(pP);
}

void links::removePlane(planeBase &plane) {
	for (int i=0; i<planes.size(); i++) {
		if (planes[i].plane==&plane) {
			planes.erase(planes.begin()+i);
			break;
		}
	}
}

vector<link> links::getLinks(planeBase& firstPlane, planeBase& secondPlane) {
	vector<link> retVector;
	for (int i=0; i<planes.size(); i++) {
		if (planes[i].plane==&firstPlane) {
			for (int j=0; j<planes.size(); j++) {
				if (planes[j].plane==&secondPlane) {
					for (int k=0; k<rowCount; k++) {
						link newLink;
						newLink.first=planes[i].rowsPoints[k].second;
						newLink.second=planes[j].rowsPoints[k].second;
						if (source.first!=-1) {
							if (planes[source.first].rowsPoints[k].first==planes[i].rowsPoints[k].first && planes[source.first].rowsPoints[k].second==source.second) {
								retVector.push_back(newLink);
							}
						} else {
							retVector.push_back(newLink);
						}
					}
					break;
				}
			}
			break;
		}
	}
	return retVector;
}

void links::findSource() {
	source.first=-1;
	source.second=-1;

	for (int i=0; i<planes.size(); i++) {
		if (planes[i].plane->getSelectedPoint()!=-1) {
			source.first=i;
			source.second=planes[i].plane->getSelectedPoint();
			break;
		}
	}
}

int links::findOrderStart() {
	int farestPlane=-1;
	float farestDist=0.0;

	planeBase *currentPlane=NULL;
	Point currentMiddle;

	for (int i=0; i<planes.size(); i++) {
		currentPlane=planes[i].plane;
		currentMiddle=currentPlane->getMiddle();
		for (int j=0; j<planes.size(); j++) {
			Point newMiddle=planes[j].plane->getMiddle();
			float curDist=pow(currentMiddle.x-newMiddle.x,2.0f)+
				pow(currentMiddle.y-newMiddle.y,2.0f)+
				pow(currentMiddle.z-newMiddle.z,2.0f);
			if (farestPlane==-1 || curDist>farestDist) {
					farestPlane=i;
					farestDist=curDist;
			}
		}
	}

	return farestPlane;
}

void links::orderPlanes() {
	findSource();
	orderedPlanes.clear();

	if (planes.size()>0) {
		vector<bool> planeConnected;
		planeConnected.resize(planes.size(), false);

		int startPlaneIndex=findOrderStart();
		planeBase *currentPlane=planes[startPlaneIndex].plane;
		orderedPlanes.push_back(currentPlane);
		planeConnected[startPlaneIndex]=true;

		Point currentMiddle=currentPlane->getMiddle();

		for (int i=1; i<planes.size(); i++) {
			int nearestPlane=-1;
			float nearestDist=0.0;
			for (int j=0; j<planes.size(); j++) {
				if (planeConnected[j]==false) {
					Point newMiddle=planes[j].plane->getMiddle();
					float curDist=pow(currentMiddle.x-newMiddle.x,2.0f)+
						pow(currentMiddle.y-newMiddle.y,2.0f)+
						pow(currentMiddle.z-newMiddle.z,2.0f);
					if (nearestPlane==-1 || curDist<nearestDist) {
							nearestPlane=j;
							nearestDist=curDist;
					}
				}
			}
			planeConnected[nearestPlane]=true;
			currentPlane=planes[nearestPlane].plane;
			orderedPlanes.push_back(currentPlane);
			currentMiddle=currentPlane->getMiddle();
		}
	}

	if (source.first!=-1) {
		vector<planeBase*> temp=orderedPlanes;

		orderedPlanes.clear();
		for (int i=0; i<temp.size(); i++) {
			if (temp[i]==planes[source.first].plane) {
				if (i<temp.size()-1) {
					for (int j=i; j<temp.size(); j++) {
						orderedPlanes.push_back(temp[j]);
					}
				}
				if (i>0) {
					for (int j=i; j>=0; j--) {
						orderedPlanes.push_back(temp[j]);
					}
				}
				break;
			}
		}
	}
}

void links::render() {
		orderPlanes();

		planeBase *firstPlane=NULL;
		planeBase *secondPlane=NULL;

		for (int i=0; i<((int)(orderedPlanes.size())-1); i++) {
			firstPlane=orderedPlanes[i];
			secondPlane=orderedPlanes[i+1];

			if (source.first==-1 || secondPlane!=planes[source.first].plane) {

				vector<link> linkVector=getLinks(*firstPlane,*secondPlane);

				// Todo: bndeln -> splines ********************************
				Point barycenter;
				Point planeCenter;

				int cnt = 0;
				bool bundleFirst = false;
				bool bundleSecond = false;
				float x = 0.0;
				float y = 0.0;
				float z = 0.0;

				for (int j=0; j<linkVector.size(); j++) {

					Point firstPoint=firstPlane->getPoint(linkVector[j].first);
					Point secondPoint=secondPlane->getPoint(linkVector[j].second);			
					Point bundle;
				
					// check if first plane should be bundled
					if (bundleFirst == false && j < linkVector.size()-1) {
						
					/*	if(firstPoint.x == firstPlane->getPoint(linkVector[j+1].first).x &&
							firstPoint.y == firstPlane->getPoint(linkVector[j+1].first).y && 
							firstPoint.z == firstPlane->getPoint(linkVector[j+1].first).z) { */
							
							for (int k=j+1; k < linkVector.size(); k++) {
								if(firstPoint.x == firstPlane->getPoint(linkVector[k].first).x &&
									firstPoint.y == firstPlane->getPoint(linkVector[k].first).y && 
									firstPoint.z == firstPlane->getPoint(linkVector[k].first).z) {
										x += secondPlane->getPoint(linkVector[k].second).x;
										y += secondPlane->getPoint(linkVector[k].second).y;
										z += secondPlane->getPoint(linkVector[k].second).z;
										cnt++;
										bundleFirst = true;
								}
							}
						//}
					}
					
					// check if second plane should be bundled
					if (bundleSecond == false && j < linkVector.size()-1) {
						/*if(secondPoint.x == secondPlane->getPoint(linkVector[j+1].second).x &&
							secondPoint.y == secondPlane->getPoint(linkVector[j+1].second).y && 
							secondPoint.z == secondPlane->getPoint(linkVector[j+1].second).z) { */
							
							for (int k=j+1; k < linkVector.size(); k++) {
								if(secondPoint.x == secondPlane->getPoint(linkVector[k].second).x &&
									secondPoint.y == secondPlane->getPoint(linkVector[k].second).y && 
									secondPoint.z == secondPlane->getPoint(linkVector[k].second).z) {
								
										x += firstPlane->getPoint(linkVector[k].first).x;
										y += firstPlane->getPoint(linkVector[k].first).y;
										z += firstPlane->getPoint(linkVector[k].first).z;
										
										cnt++;
										bundleSecond = true;
								}			
							}
						//}
					}

								
					bundle.x = x / float(cnt);
					bundle.y = y / float(cnt);
					bundle.z = z / float(cnt);

					if (bundleFirst == true) {	
						barycenter.x = (bundle.x + firstPoint.x) / 2.0;
						barycenter.y = (bundle.y + firstPoint.y) / 2.0;
						barycenter.z = (bundle.z + firstPoint.z) / 2.0;
					}
					else if (bundleSecond == true) {
						barycenter.x = (bundle.x + secondPoint.x) / 2.0;
						barycenter.y = (bundle.y + secondPoint.y) / 2.0;
						barycenter.z = (bundle.z + secondPoint.z) / 2.0;
					}
					else {
						barycenter.x = (firstPoint.x + secondPoint.x) / 2.0;
						barycenter.y = (firstPoint.y + secondPoint.y) / 2.0;
						barycenter.z = (firstPoint.z + secondPoint.z) / 2.0;
					}
		
					// estimate points for spline
					splineStart.clear();
					splineAfter.clear();
					splineStart.push_back(firstPoint);
					splineStart.push_back(barycenter);
					splineStart.push_back(secondPoint);
					int cntPoints = 2;

					for (int m=0; m < 4; m++) {
						for (int k=0; k < cntPoints; k++) {
							calcSpline(k, k+1);
						}
						splineStart = splineAfter;
						splineStart.insert(splineStart.begin(), firstPoint);
						splineStart.push_back(secondPoint);
						cntPoints = splineStart.size()-1;
						splineAfter.clear();
					}


					glLoadIdentity();

					glLineWidth(1.2);
					for (int k=0; k < splineStart.size()-1; k++) {
						glBegin(GL_LINES);
							glColor3f(1.0 - 1.0/splineStart.size()*k, 1.0/splineStart.size()*k, 0.0); 
							glVertex3f(splineStart.at(k).x, splineStart.at(k).y, splineStart.at(k).z);
							glColor3f(1.0 - 1.0/splineStart.size()*(k+1), 1.0/splineStart.size()*(k+1), 0.0); 
							glVertex3f(splineStart.at(k+1).x, splineStart.at(k+1).y, splineStart.at(k+1).z);
						glEnd();
					}
				}

				// **********************************************************
			}
		}
}


void links::calcSpline(int index1, int index2) {
	Point p1 = splineStart.at(index1);
	Point p2 = splineStart.at(index2);
	Point newPoint;

	newPoint.x = 3.0/4.0*p1.x + 1.0/4.0*p2.x;
	newPoint.y = 3.0/4.0*p1.y + 1.0/4.0*p2.y;
	newPoint.z = 3.0/4.0*p1.z + 1.0/4.0*p2.z;

	splineAfter.push_back(newPoint);
	
	newPoint.x = 1.0/4.0*p1.x + 3.0/4.0*p2.x;
	newPoint.y = 1.0/4.0*p1.y + 3.0/4.0*p2.y;
	newPoint.z = 1.0/4.0*p1.z + 3.0/4.0*p2.z;

	splineAfter.push_back(newPoint);
}