#ifndef GLWIDGET_H
#define GLWIDGET_H

#include <windows.h>
#include <glew.h>
#include <gl\gl.h>
#include <GL\glut.h>


#include <QtGui\QtGui>
#include <QtOpenGL\QtOpenGL>
#include <QtGui\QWidget>
#include <iostream>

#include "Data.h"
#include "Timer.h"
#include "planeMap.h"
#include "planeAdmin.h"

class QPushButton;

/**
* The man GL window.
*/
class GLWidget : public QGLWidget {
	Q_OBJECT
	public:
		/** type that is deleted chosed from "x" of a plane */
		int delType;

		/** column that is deleted chosed from "x" of a plane */
		int delCol;

		/** width of GLWindow */
		int width;

		/** height of GLWindow */
		int height; 

		/** const for distinction between map, bar and pie */
		static const int PLANE_MAP = 1;

		/** const for distinction between map, bar and pie */
		static const int PLANE_BAR = 2;

		/** const for distinction between map, bar and pie */
		static const int PLANE_PIE = 3;

		/** constant for checking if loaded type is string */
		static const int TYPE_STRING = 1;

		/** constant for checking if loaded type is float */
		static const int TYPE_FLOAT  = 2;

		/** constant for checking if loaded type is float and should be displayed as percent */
		static const int TYPE_PERCENT = 3;

		/** Constructor of GLWidget class. It generates the paint window and all painted stuff. */
		GLWidget(QWidget *parent = 0);

		/** set minimum size of window */
		QSize minimumSizeHint() const;

		/** set actual size of window */
		QSize sizeHint() const;

		/** resize window */
		void resizeGL(int w, int h);

		/** loads data from file into data structure 
		    @param filename filename from actual loaded file */
		bool loadData(QString filename);

		/** return title from loaded data (this is the first row in data-file) 
		    @return returns a vectory containing QStrings of all column description */
		vector<QString> getTitle();

		/** return all types of the columns 
		    @return returns a vector containing int for the different types of float, string, percent */
		vector<int> getType();

		/** adds new plane to environment 
			 @param planeType defines the type of plane (map, bar or pie)
			 @param col defines what columns are used for that plane
			 @param x defines x position of new plane
			 @param y defines y position of new plane
			 @param z defines z position of new plane
			 @param rotX defines x rotation of new plane
			 @param rotY defines y rotation of new plane */
		void addPlane(int planeType, vector<int> col, int x, int y, int z, int rotX, int rotY);

		/** removes chosen plane 
		    @param planeType defines what type of plane (map, bar or pie)
			 @param index defines by the help of an index what plane should be removed */
		void removePlane(int planeType, int index);

		/** animat plane to 2D
		    @param type defines what type of plane (map, bar or pie)
			 @param index defines by the help of an index what plane should animated */
		void to2D(int type, int index);
		
		/** animat plane to 3D
		    @param type defines what type of plane (map, bar or pie)
			 @param index defines by the help of an index what plane should animated */
		void to3D(int type, int index);

		/** defines what type should be updated when animation is active */
		int updType;
		
		/** defines if animation should be updated */
		int updMode;

	private:
		/** set width of GLWindow */
		int initwidth;

		/** set height of GLWindow */
		int initheight; 

		/** data structure for loaded data */
		Data *dat; 

		/** initializes all stuff for GLWindow and painting */
		void initializeGL();

		/** paints the scene */
		void paintGL();

		/** contains all planes do rendering */
		planeAdmin *masterPlane;

		/** timer for be invariant against processor */
		Timer timer;

		//bool test2d;
		//float testincT;

		/** destructor of glWidget class */
		~GLWidget(void);

		/** if mouse is pressed 
			 @param event mouse event, that occured */
		void mousePressEvent(QMouseEvent *event);

		/** if mouse is release 
			 @param event mouse event, that occured */
		void mouseReleaseEvent(QMouseEvent *event);

		/** if mouse is moved 
			 @param event mouse event, that occured */
		void mouseMoveEvent(QMouseEvent *event);
		
		/** if key is pressed
			 @param e key event, that occured (what key is pressed?) */
		void keyPressEvent(QKeyEvent* e);
		
		/** if mouse is pressed 
			 @param event mouse event, that occured */
		void keyReleaseEvent(QKeyEvent* e);

		/** if strg key is pressed -> plane update is possible */
		bool navigate;

signals:
	/** update GUI if plane is animated to another mode */
	void updateGUI();

	/** set visibility of GUI if animation mode is changed */
	void visibleGUI();
};

#endif
