#include "GLWidget.h"
#include "data.h"


GLWidget::GLWidget(QWidget *parent) : QGLWidget(parent) {
// constructor for GLWidget
	setFocusPolicy(Qt::StrongFocus);
	navigate=false;

	setMouseTracking(true);

	dat = new Data();
}

GLWidget::~GLWidget(void) {
/*	delete testplane;
	delete testplane2;*/
}

void GLWidget::initializeGL() {
// initializes GLWindow and all painting stuff
	initwidth = 1024;
	initheight = 768;

	GLenum err = glewInit();
	if (err != GLEW_OK)
	{
		printf("Error initializing GLEW");
		std::cerr << "Error initializing GLEW: " << glewGetErrorString(err) << std::endl;
	}

	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	glDepthFunc(GL_LEQUAL);


	glEnable(GL_DEPTH_TEST);
	// nur zum testen *****************
/*	testplane=new planeMap();
	testplane->init();
	testplane->setPos(2,2,-7);
	testplane->setRot(0,40);

	testplane2=new planeMap();
	testplane2->init();
	testplane2->setPos(1.2,2,-7.6);
	testplane2->setRot(0,30);

	test2d=false;
	testincT=0;*/
	//*****************************

	masterPlane = new planeAdmin();
	masterPlane->setParent(this);

	glClearColor(1.0,1.0,1.0,1.0);

	setFocus();
	paintGL();
}

void GLWidget::paintGL() {
// do painting

	float dT=float(timer);
	timer.start();
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	/*
	// **** nur zum testen
	testincT+=dT;
	if (!test2d && testincT>3.0 && testincT<3.1) {
		test2d=true;
		testplane->animateTo2D();
	}

	if (test2d && testincT>7.0) {
		test2d=false;
		testplane->animateTo3D();
		testincT=0.0;
	}

	*/
	//testplane2->render(dT);
	//testplane->render(dT);
	// ************************

	if (masterPlane->bupdateGUI) {
		delType = masterPlane->delInfo.type;
		delCol = masterPlane->delInfo.column;
		masterPlane->bupdateGUI = false;
		emit updateGUI();
	}


	if (masterPlane->act2DModeChanged) {
		cout << updMode << endl;
		updType = masterPlane->act2DModeType;
		updMode = masterPlane->next2DMode;
		masterPlane->act2DModeChanged = false;
		emit visibleGUI();
	}


	//printf("\nfps: %f", 1.0/dT);

	masterPlane->renderAll(dT);
	
	update();
}

QSize GLWidget::minimumSizeHint() const {
// set minimum size
     return QSize(initwidth, initheight);
 }

QSize GLWidget::sizeHint() const {
// set actual size
 return QSize(initwidth, initheight);
} 

bool GLWidget::loadData(QString filename) {
 // loads data from file

	 return dat->loadData(filename);
 }

 vector<QString> GLWidget::getTitle() {
	 return dat->getTitle();
 }

 vector<int> GLWidget::getType() {
	return dat->getType();
 }

void GLWidget::resizeGL(int w, int h) {
	width = w;
	height = h;
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glViewport(0, 0, (GLint)w,(GLint)h);
	gluPerspective(60,(float)w/h,1.0,1000);
	glMatrixMode(GL_MODELVIEW);
 }

void GLWidget::addPlane(int planeType, vector<int> col, int x, int y, int z, int rotX, int rotY) {
	masterPlane->addPlane(planeType, dat, col, x, y, z, rotX, rotY);
}

void GLWidget::removePlane(int planeType, int index) {
	masterPlane->deletePlane(planeType, index);
}

void GLWidget::mousePressEvent(QMouseEvent *event) {
	if (!navigate) {
		masterPlane->picking((float)event->pos().x(), (float)event->pos().y());
	} else {
		if (event->button()==Qt::LeftButton) {
			masterPlane->navigate((float)event->pos().x(), (float)event->pos().y(),0);
		}
		if (event->button()==Qt::MidButton) {
			masterPlane->navigate((float)event->pos().x(), (float)event->pos().y(),1);
		}
	}
}

void GLWidget::mouseReleaseEvent(QMouseEvent *event) {
	masterPlane->navigateRelease();
}

void GLWidget::mouseMoveEvent(QMouseEvent *event) {
	if (navigate) {
		masterPlane->mouseMove((float)event->pos().x(), (float)event->pos().y());
	}
}

void GLWidget::keyPressEvent(QKeyEvent* e) {
	if (e->key()==16777249) {
		navigate=true;
		masterPlane->showNavigators();
		printf("\nnavigate");
	}
}

void GLWidget::keyReleaseEvent(QKeyEvent* e) {
	if (e->key()==16777249) {
		navigate=false;
		masterPlane->hideNavigators();
		masterPlane->navigateRelease();
		printf("\nrelease navigate");
	}
}

void GLWidget::to2D(int type, int index) {
	masterPlane->to2D(type, index);
}

void GLWidget::to3D(int type, int index) {
	masterPlane->to3D(type, index);
}