#include <windows.h>
#include <gl\gl.h>

#pragma once

/**
* Can be used to write text.
*/
class Font
{
	/** display list for font */
	GLuint fontBase;		

	/** address of buffer to recieve data */
	GLYPHMETRICSFLOAT	gmf[256];	

public:

	/** constructor of font class */
	Font(void);

	/** destructor of font class */
	~Font(void);

	/** creates new font. 
		 @param
		 @param
		 @param
		 @param */
	void createFont(int size, char* type, HDC hdc, int style);	// erzeugt neuen Font
	
	/** destroy font */
	void destroyFont();											// zerstrt Font
	
	/** prints given string
	    @param string that is printed */
	void printFont(char* s);									// gibt Font aus
	
	/** prints string by the use of how many parameters you need like fprintf
	    @param string that is printed 
		 @param ... how many parameters you need */
	void printFont(const char *s, ...);
};
