#include "Font.h"

#include <math.h>
#include <stdio.h>
#include <stdarg.h>
#include <iostream>
#include <string>
#include <windows.h>
#include <gl\gl.h>		// OpenGL Library
#include <gl\glut.h>	// Window-Handling Library

using namespace std;


Font::Font(){
}

Font::~Font(){
}

void Font::createFont(int size, char* type, HDC hdc, int style){
					// Address Buffer For Font Storage
	HFONT	font;				

	fontBase = glGenLists(96);

	font = CreateFont(size, 
						0, 
						0, 
						0, 
						style, 
						FALSE, 
						FALSE, 
						FALSE, 
						ANSI_CHARSET, 
						OUT_TT_PRECIS, 
						CLIP_DEFAULT_PRECIS, 
						ANTIALIASED_QUALITY, 
						FF_DONTCARE|DEFAULT_PITCH, 
						type);
	
//	oldfont = (HFONT)SelectObject(hdc, font);
//	wglUseFontBitmaps(hdc, 32, 96, fontBase);

	SelectObject(hdc, font);
//	DeleteObject(font);
	wglUseFontOutlines(	hdc,							// Select The Current DC
					0,								// Starting Character
					255,							// Number Of Display Lists To Build
					fontBase,					// Starting Display Lists
					0.1f,							// Deviation From The True Outlines
					0.2f,							// Font Thickness In The Z Direction
					WGL_FONT_POLYGONS,				// Use Polygons, Not Lines
					gmf);							// Address Of Buffer To Recieve Data
}

void Font::destroyFont(){
	glDeleteLists(fontBase, 96);
}

void Font::printFont(char *s){
	// falls ein Wert berliefert wird
	if (s != NULL){
		glPushAttrib(GL_LIST_BIT); 	// Listen nicht berschrieben werden
		glListBase(fontBase);	// gewnschten Buchstaben zu finden
		
		glCallLists(strlen(s), GL_UNSIGNED_BYTE, s); // ruft die angegebenen Listen auf
		glPopAttrib();				// setzt GL_LIST_BIT wieder auf Anfang
	}
}

/*
void Font::printFont(const char *s, ...) 
{
	if (s != NULL){
		char text[256]; 		
		va_list ap; 		
		glColor3f(1,1,1);
		va_start(ap, s); 				
		vsprintf(text, s, ap); 		
		va_end(ap); 			

		glPushAttrib(GL_LIST_BIT); 	
		glListBase(fontBase); 			

		glCallLists(strlen(text), GL_UNSIGNED_BYTE, text);
		glPopAttrib(); 
	}
}
*/

GLvoid Font::printFont(const char *fmt, ...)					// Custom GL "Print" Routine
{
	float		length=0;								// Used To Find The Length Of The Text
	char		text[256];								// Holds Our String
	va_list		ap;										// Pointer To List Of Arguments

	if (fmt == NULL)									// If There's No Text
		return;											// Do Nothing

	va_start(ap, fmt);									// Parses The String For Variables
	    vsprintf(text, fmt, ap);						// And Converts Symbols To Actual Numbers
	va_end(ap);											// Results Are Stored In Text

	for (unsigned int loop=0;loop<(strlen(text));loop++)	// Loop To Find Text Length
	{
		length+=gmf[text[loop]].gmfCellIncX;			// Increase Length By Each Characters Width
	}

	glTranslatef(-length/2,0.0f,0.0f);					// Center Our Text On The Screen

	glPushAttrib(GL_LIST_BIT);							// Pushes The Display List Bits
	glListBase(fontBase);									// Sets The Base Character to 0
	glCallLists(strlen(text), GL_UNSIGNED_BYTE, text);	// Draws The Display List Text
	glPopAttrib();										// Pops The Display List Bits
}