#pragma once

#include <QtGui\QtGui>
#include <Qt\QFile.h>
#include <Qt\QApplication.h>
#include <Qt\QTextStream.h>
#include <Qt\QIODevice.h>
#include <iostream>
#include <stdio.h>
#include <vector>

using namespace std;

struct dataInfo {
	float valFloat;
	QString valString;
	int type;
};

/**
* Data class holds the dataset
*/
class Data
{
	private:

		/** contains the first line of data. This line contains the title of the columns */
		vector<QString> title;

		/** contains the second line of data. This line contains the types of the columns */
		vector<int> type;

		/** contains remaining data */
		vector< vector <dataInfo> > dat;

		/** describes how large the vector is that means how many attributes are available */
		int datSize;

	public:
		
		/** constant for checking if loaded type is string */
		static const int TYPE_STRING = 1;

		/** constant for checking if loaded type is float */
		static const int TYPE_FLOAT  = 2;

		/** constant for checking if loaded type is a float that should be used like percent */
		static const int TYPE_PERCENT  = 3;

		/** Constructor of Data class. */
		Data(void);

		/** Destructor of Data class. */
		~Data(void);

		/** loads data from file into data structure 
		    @param filename filename from actual loaded file */
		bool loadData(QString filename);

		/** return one line of data
			 @param index this is the index of the wanted line 
			 @return this function returns a vector that contains all columns in the form of dataInfo */
		vector<dataInfo> getLine(int index);

		/** returns one column of a given line
			 @param index this is the index of the actual line
			 @param col this is the column of the wanted data item 
			 @return returns data in form of dataInfo */
		dataInfo getValue(int index, int col);

		/** dummy function -> prints loaded data */
		void printData();

		/** get back title from loaded file 
		    @return return value is a vector with QStrings that contains all titles */
		vector<QString> getTitle();

		/** get back types from loaded file 
		    @return return value is a vector with integers that contains all types */
		vector<int> getType();

		/** returns the count of data 
		    @return count of data */
		int getSize();
};
