#include "Data.h"

Data::Data(void) {
}

Data::~Data(void) {
	
}

bool Data::loadData(QString filename) {
// loads data from file. filename contains the choosen file and path

	QFile file(filename);
	if ( file.exists() ) {
		if (file.open( QIODevice::ReadOnly )) {
			QStringList attributes;
			QTextStream stream (&file);
			QString line;

			dat.clear();
			title.clear();
			type.clear();
			datSize = 0;

			// read first line for title
			line = stream.readLine();
			attributes = line.split(";");

			for ( QStringList::Iterator it = attributes.begin(); it != attributes.end(); ++it ) {
				title.push_back(QString(*it));
			}

			// read second line for type
			line = stream.readLine();
			attributes = line.split(";");

			for ( QStringList::Iterator it = attributes.begin(); it != attributes.end(); ++it ) {
				QString item = QString(*it);

				if (QString::compare(item, "string") == 0)
					type.push_back(TYPE_STRING);
				else if (QString::compare(item, "float") == 0)
					type.push_back(TYPE_FLOAT);
				else if (QString::compare(item, "percent") == 0)
					type.push_back(TYPE_PERCENT);
			}

			vector<dataInfo> vec;
			dataInfo inf;
			int i;
			datSize = 0;

			// read other data with information
			while(!stream.atEnd()) {
				line = stream.readLine();
				attributes = line.split(";");

				i = 0;
				vec.clear();
				// iterate through attributes and save attributes into a vector
				for ( QStringList::Iterator it = attributes.begin(); it != attributes.end(); ++it ) {
					
					if (type.at(i) == TYPE_FLOAT) {
						inf.valFloat = atof((const char *)QString(*it).toLatin1());
						inf.type = TYPE_FLOAT;
					}
					else if (type.at(i) == TYPE_PERCENT) {
						inf.valFloat = atof((const char *)QString(*it).toLatin1());
						inf.type = TYPE_PERCENT;
					}
					else if (type.at(i) == TYPE_STRING) {
						inf.valString = QString(*it);
						inf.type = TYPE_STRING;
					}
					vec.push_back(inf);
					i++;
				}
				// save line in another vector
				dat.push_back(vec);
				datSize++;
			}
		}
		else {
			cout << "error - can't open file" << endl;
			return false;
		}
		file.close();
	}
	else {
		cout << "error - no such file found!" << endl;
		return false;
	}
	return true;
}

void Data::printData() {
// dummy function -> prints data

	vector<dataInfo> bla;

	// itterates all lines
	for (int j=0; j < datSize; j++) {
		bla = dat.at(j);	

		// iterates through attributes
		for (int i=0; i < bla.size(); i++) {
			if (bla.at(i).type == 1) 
				cout << (string)bla.at(i).valString.toLatin1() << ";";
			else
				cout << bla.at(i).valFloat << ";";
		}
		cout << endl;
	}
}

vector<dataInfo> Data::getLine(int index) {
// return line at index
	return dat.at(index);
}

dataInfo Data::getValue(int index, int col) {
// return dataInfo at index and col
	vector<dataInfo> tmp = dat.at(index);
	return tmp.at(col);
}

vector<QString> Data::getTitle() {
// return title
	return title;
}

vector<int> Data::getType() {
// return type
	return type;
}

int Data::getSize() {
// return size
	return datSize;
}