//
//  ArcDiagramView.h
//  guiTest
//
//  Created by David Palme on 29.05.07.
//  Copyright 2007 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import <Arc.h>

/*!
	@class ArcDiagramView
	@abstract class implementing the view that displays the analysed string and the diagrams above.
*/

@interface ArcDiagramView : NSView
{
	NSMutableSet *arcs;
	NSAttributedString *superString;
	NSRect superStringRect;
	
	NSPoint grabOrigin;
	NSPoint scrollOrigin;
}

//prepare arguments for NSStringWithArguments
//safeAsPDF
//autoscroll

//overritten
- (id)initWithFrame:(NSRect)frame;
- (void)drawRect:(NSRect)rect;

/*!
	@method setSuperString:
	@abstract set the string to be displayed.
*/
- (void)setSuperString:(NSAttributedString *)aString;

/*!
	@method setArcsWithSet:
	@abstract sets the arc representations with an NSArray containing NSBezierPaths.
*/
- (void)setArcsWithSet:(NSMutableSet *)aSet;

@end
