//
//  ArcDiagramController.h
//  Arcs
//
//  Created by the cell on 6/10/07.
//  Copyright 2007 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import "MatchingPair.h"
#import "RepetitionRegion.h"
#import "Arc.h"
#import "ArcDiagramView.h"

/*!
	@class ArcDiagramController
	@abstract cotroller class for the ArcDiagramView.
*/

@interface ArcDiagramController : NSObject
{
	ArcDiagramView *arcDiagramView;
	NSString *superString;
	NSRect superStringRect;
	NSArray *essentialMatchingPairs;
	NSArray *arcs;
	NSMutableSet *arcDiagrams;
	
	NSMutableDictionary *attributes;
}

/*!
	@method initWithView:
	@abstract initialises a new arc diagram controller with a given arc diagram view.
*/
- (id)initWithView:(ArcDiagramView *)aArcDiagramView;

/*!
	@method setEssentialMatchingPairs:
	@abstract sets a list of essential matching pairs.
*/
- (void)setEssentialMatchingPairs:(NSArray *)someEssentialMatchingPairs;

/*!
	@method setSuperString:
	@abstract sets string to be displayed.
*/
- (void)setSuperString:(NSString *)aString;

/*!
	@method prepareSuperStringAttributes
	@abstract sets string attributes. fonts, size etc.
*/
- (void)prepareSuperStringAttributes;

/*!
	@method calculateArcs
	@abstract calculates arcs with the list of matching pairs.
*/
- (void)calculateArcs;

/*!
	@method renderView
	@abstract prepare arc diagram view and call it to render.
*/ 
- (void)renderView;

@end
