#ifndef H_APPCONTROLLER
#define H_APPCONTROLLER

#import <Cocoa/Cocoa.h>

#import <iLifeControls/NFHUDWindow.h>
#import "Arc.h"
#import "ArcDiagramView.h"
#import "ArcDiagramController.h"
#import "InputPanelController.h"
#import "RepetitionFinder.h"

/*!
	@class AppController
	@discussion controller for the main application flow.
*/

@interface AppController : NSObject
{
	//variables are private
	IBOutlet NSMenuItem *menuItemInputPanel;
	
	IBOutlet NFHUDWindow *arcInspectorHUDPanel;	
	NSWindowController *inputPanelController;
	
	IBOutlet NSWindow *arcDiagramWindow;
	IBOutlet ArcDiagramView *arcDiagramView;
}

- (void)awakeFromNib;
- (IBAction)open:(id)sender;

/*!
	@method drawArcsWithString:andMinimalRepetitionLength:
	@abstract draws arc diagrams for a string with a minimal repetition length.
	@param aString  a string to be visualized.
	@param minimalLength  minimal repetition length.
*/
- (void)drawArcsWithString:(NSString *)aString andMinimalRepetitionLength:(int)minimalLength;

- (IBAction)showInputPanel:(id)sender;

@end
#endif