//
//  InputPanelController.h
//  guiTest
//
//  Created by David Palme on 22.05.07.
//  Copyright 2007 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import "AppController.h"

@interface InputPanelController : NSWindowController
{
	IBOutlet NSTabView *inputTabView;
	NSTabViewItem *directInputTabViewItem;
	NSTabViewItem *fileInputTabItem;
	NSTabViewItem *selectedInputTabViewItem;

	IBOutlet NSTextView *directInputTextView;
	
	IBOutlet NSButton *chooseFileButton;
	IBOutlet NSTextField *inputFileName;
	NSString *filePath;

	IBOutlet NSButton *ignoreWhitespaceButton;
	IBOutlet NSButton *ignoreCaseButton;
	IBOutlet NSSlider *minimumRepetitionLengthSlider;
	IBOutlet NSTextField *minimumRepetitionLengthValue;
	IBOutlet NSProgressIndicator *progressIndicator;
	IBOutlet NSButton *drawArcsButton;
}

//overritten methods

//delegate methods
- (void)awakeFromNib;
- (void)tabView:(NSTabView *)tabView willSelectTabViewItem:(NSTabViewItem *)tabViewItem;
- (void)openPanelDidEnd:(NSOpenPanel *)openPanel returnCode:(int)returnCode contextInfo:(void *)x;

//own implementation
- (id)initWithAppController:(id)aAppController;
- (IBAction)open:(id)sender;
- (IBAction)drawArcs:(id)sender;

- (void)animateProgressIndicator;
- (void)stopProgressIndicator;
- (IBAction)setMinimumRepetitionLengthString:(id)sender;

@end
