/* AppController */
#ifndef H_APPCONTROLLER
#define H_APPCONTROLLER

#import <Cocoa/Cocoa.h>

#import <iLifeControls/NFHUDWindow.h>
#import "Arc.h"
#import "ArcDiagramView.h"
#import "ArcDiagramController.h"
#import "InputPanelController.h"
#import "RepetitionFinder.h"


@interface AppController : NSObject
{
	IBOutlet NSMenuItem *menuItemInputPanel;
	
	IBOutlet NFHUDWindow *arcInspectorHUDPanel;	
	NSWindowController *inputPanelController;
	
	IBOutlet NSWindow *arcDiagramWindow;
	IBOutlet ArcDiagramView *arcDiagramView;
}

- (void)awakeFromNib;
- (IBAction)open:(id)sender;

- (void)drawArcsWithString:(NSString *)aString andMinimalRepetitionLength:(int)minimalLength;

- (IBAction)showInputPanel:(id)sender;

@end
#endif