//
//  RepetitionRegion.h
//  ArcParser
//
//  Created by pia palme on 5/14/07.
//  Copyright 2007 __MyCompanyName__. All rights reserved.
//
#ifndef H_REPETITIONREGION
#define H_REPETITIONREGION

#import <Cocoa/Cocoa.h>

#import "MatchingPair.h"

/*!
	@class RepetitionRegion
	@abstract class for a repetition region.
	@discussion a repetition region is a region in a string build of a fundamental substring s two or more times in intermediate succession.
*/

@interface RepetitionRegion : NSObject
{
	NSString *fundamentalSubstring;
	NSRange range;
}

/*!
	@method initWithFundamentalSubstring:fromIndex:withLength:
	@abstract initialises a repetition region with a fundamental substring from an index with a length.
*/
- (id)initWithFundamentalSubstring:(NSString *)aFundamentalSubstring fromIndex:(int)rangeStart withLength:(int)rangeLength;

/*!
	@method initWithFundamentalSubstring:inRange:
	@abstract initialises a repetition region with a fundamental substring in a certain range.
*/
- (id)initWithFundamentalSubstring:(NSString *)aFundamentalSubstring inRange:(NSRange)aRange;

/*!
	@method fundamentalSubstring
	@abstract returns the fundamental substring.
*/
- (NSString *)fundamentalSubstring;

/*!
	@method completeString
	@abstract returns the repetition region's complete string representation.
*/
- (NSString *)completeString;

/*!
	@method range
	@abstract returns range the repetition region is in.
*/
- (NSRange)range;

/*!
	@method repetitions
	@abstract returns nuber of repetitions of the fundamental substring.
*/
- (int)repetitions;

/*!
	@method startLocation
	@abstract returns the location of the first repetition.
*/
- (int)startLocation;

/*!
	@method length
	@abstract returns the repetition region's complete length.
*/
- (int)length;

/*!
	@method containsRangeFrom:
	@abstract returns YES if the repetition region's range contains the range from another region.
*/
- (BOOL)containsRangeFrom:(RepetitionRegion *)aRepetitionRegion;

/*!
	@method fundamentalSubstringContainsRangeFrom:
	@abstract returns YES if the repetition region's fundamental substring contains the range from another region.
*/
- (BOOL)fundamentalSubstringContainsRangeFrom:(RepetitionRegion *)aRepetitionRegion;

/*!
	@method repetitionRegionStartingInLastRepetition:
	@abstract returns YES if another repetition region satrts in the last repetition of the fundamental substring.
*/
- (BOOL)repetitionRegionStartingInLastRepetition:(RepetitionRegion *)aRepetitionRegion;

/*!
	@method containsIntersectingRangeFrom:
	@abstract returns YES if the repetition region contains another repetition region in two consecutive substrings. eg: 1000110001 contains 11 intersecting.
*/
- (BOOL)containsIntersectingRangeFrom:(RepetitionRegion *)aRepetitionRegion;

/*!
	@method overlappedByRangeFrom:
	@abstract returns YES if the repetition region is overlapped by antoher region.
*/
- (BOOL)overlappedByRangeFrom:(RepetitionRegion *)aRepetitionRegion;

/*!
	@method splitIntersectingRepetitionRegion:
	@abstract splits another intersecting repetition region in the intersecting point.
	@result  splitted regions in an NSArray if splitting is possible, nil if not.
*/
- (NSArray *)splitIntersectingRepetitionRegion:(RepetitionRegion *)aRepetitionRegion;

/*!
	@method splitOnIndex:
	@abstract splits repetition region index.
	@result  splitted regions in an NSArray if splitting is possible, nil if not.
*/
- (NSArray *)splitOnIndex:(int)index;

/*!
	@method trunkateWith:
	@abstract trunkates repetition region based on an overlapping other region. eg in ab11ab(1111), (1111 trunkateWith: ab11) = 11 (depending on locations)
	@result  YES if the repetition region was trunated by the overlapping piece of another regioin, NO if trunkation was not possible.
*/
- (BOOL)trunkateWith:(RepetitionRegion *)aRepetitionRegion;

/*!
	@method printToLog
	@abstract prints the repetition to NSLog().
*/
- (void)printToLog;

//operations with matching pairs
//- (BOOL)matchingPairIsConsecutiveFundamentalSubstring:(MatchingPair *)aMatchingPair;
//- (BOOL)containsMatchingPairInFundamentalSubstring:(MatchingPair *)aMatchingPair;

@end

#endif