//
//  RepetitionFinder.h
//  ArcParser
//
//  Created by David Palme on 15.04.07.
//  Copyright 2007 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import "RepetitionRegion.h"
#import "MatchingPair.h"

/*!
	@class RepetitionFinder
	@abstract class for parsing a string for repetitions and calculating repetition regions and matching pairs.
*/

@interface RepetitionFinder : NSObject
{
	NSString *superString;
	int minimalRepetitionLength;
	NSMutableArray *dictionaries;
	NSArray *checkedRepetitionRegions;
	NSArray *essentialMatchingPairs;
}

/*!
	@method initWithString:
	@abstract initialises a new repetition finder with a string to be parsed.
*/
- (id)initWithString:(NSString *)aString;

/*!
	@method setString:
	@abstract sets the string to be parsed.
*/
- (void)setString:(NSString *)aString;

/*!
	@method prepare
	@abstract prepares datastructure for calculation.
*/
- (void)prepare;

/*!
	@method prepareWithString:
	@abstract sets string to be parsed and prepares datastructure for calculation.
*/
- (void)prepareWithString:(NSString *)aString;

/*!
	@method essentialMatchingPairsWithMinimalRepetitionLength:
	@abstract call only if prepared. calculates the essential mathing pairs in the string with a minimal repetitionlength.
	@result  NSArray that contains all essential matching pairs.
*/
- (NSArray *)essentialMatchingPairsWithMinimalRepetitionLength:(int)minimalLength;

/*!
	@method printToLog
	@abstract prints the repetition finder to NSLog().
*/
- (void)printToLog;

@end
