//
//  MatchingPair.h
//  ArcParser
//
//  Created by the cell on 5/31/07.
//  Copyright 2007 __MyCompanyName__. All rights reserved.
//

#ifndef H_MATCHINGPAIR
#define H_MATCHINGPAIR

#import <Cocoa/Cocoa.h>

#import "RepetitionRegion.h"

/*!
@class MatchingPair
@discussion class for a matching pair.
*/

@interface MatchingPair : NSObject
{
	NSString *string;
	int firstLocation;
	int secondLocation;
	//RepetitionRegion *partOfRepetitionRegion;
}


/*!
	@method initWithString:firstLocation:secondLocation:
	@abstract initialises a new matching pair.
	@param aString  repeated string.
	@param aFirstLocation  first location of the string (0 ... n-1).
	@param aSecondLocation  second location of the string (0 ... n-1).
*/
- (id)initWithString:(NSString *)aString firstLocation:(int)aFirstLocation secondLocation:(int)aSecondLocation;

/*!
	@method string
	@abstract returns the repeted string.
*/
- (NSString *)string;

/*!
	@method length
	@abstract returns the matching pair's spanning length. 
*/
- (int)length;

/*!
	@method stringLength
	@abstract returns the length of the repeated string.
*/
- (int)stringLength;

/*!
	@method firstLocation
	@abstract returns the first location of the repeated string.
*/
- (int)firstLocation;

/*!
	@method secondLocation
	@abstract returns the second location of the repeated string.
*/
- (int)secondLocation;

/*!
	@method firstRange
	@abstract returns the range of the first string ocurrence.
*/
- (NSRange)firstRange;

/*!
	@method secondRange
	@abstract returns the range of the second string ocurrence.
*/
- (NSRange)secondRange;

/*!
	@method distanceFromFirstLocationToSecondLocation
	@abstract returns the distance from the first to the second location.
*/
- (int)distanceFromFirstLocationToSecondLocation;

/*!
	@method distanceBetweenStrings
	@abstract returns the distance between the two string ocurrences.
*/
- (int)distanceBetweenStrings;

/*!
	@method contains
	@abstract returns YES if a matching pair contains anothers ocurrences (abcd.abcd contains .bc...bc.).
*/
- (BOOL)contains:(MatchingPair *)aMatchingPair;

/*!
	@method equals
	@abstract returns YES if the matching pairs are identical in string and ocurrences.
*/
- (BOOL)equals:(MatchingPair *)aMatchingPair;

/*!
	@method printToLog
	@abstract prints the matching pair to the NSLog.
*/
- (void)printToLog;

//- (void)setPartOfRepetitionRegion:(RepetitionRegion *)aRepetitionRegion;
//- (RepetitionRegion *)repetitionRegion;
//- (BOOL)isPartOfARepetitionRegion;

@end

#endif