//
//  InputPanelController.m
//  guiTest
//
//  Created by David Palme on 22.05.07.
//  Copyright 2007 __MyCompanyName__. All rights reserved.
//

#import "InputPanelController.h"

AppController *appController;

IBOutlet NSTabView *inputTabView;
NSTabViewItem *directInputTabViewItem;
NSTabViewItem *fileInputTabViewItem;
NSTabViewItem *selectedInputTabViewItem;

IBOutlet NSTextView *directInputTextView;

IBOutlet NSButton *chooseFileButton;
IBOutlet NSTextField *inputFileName;
NSString *filePath = nil;

IBOutlet NSButton *ignoreWhitespaceButton;
IBOutlet NSButton *ignoreCaseButton;
IBOutlet NSSlider *minimumRepetitionLengthSlider;
IBOutlet NSTextField *minimumRepetitionLengthValue;
IBOutlet NSProgressIndicator *progressIndicator;
IBOutlet NSButton *drawArcsButton;

@implementation InputPanelController

- (id)initWithAppController:(id)aAppController
{
	self = [super initWithWindowNibName:@"InputPanel"];
	
	[aAppController retain];
	appController = aAppController;
	
	return self;
}

- (void)awakeFromNib
{
	NSLog(@"input panel awake ...");
	
	directInputTabViewItem = [inputTabView tabViewItemAtIndex:0];
	fileInputTabViewItem = [inputTabView tabViewItemAtIndex:1];
	
	[inputTabView selectTabViewItem:directInputTabViewItem];
	selectedInputTabViewItem = directInputTabViewItem;
}

- (void)openPanelDidEnd:(NSOpenPanel *)openPanel returnCode:(int)returnCode contextInfo:(void *)x
{
	if (returnCode == NSOKButton)
	{
		filePath = [openPanel filename];
		[filePath retain];
		
		//set gui
		[inputFileName setStringValue:[filePath lastPathComponent]];
	}
}

- (IBAction)open:(id)sender
{
	NSMutableArray *fileTypes = [NSMutableArray array];
	[fileTypes addObject:@"txt"];
	[fileTypes addObject:@"html"];
	[fileTypes addObject:@"xml"];
	[fileTypes addObject:@"css"];

	NSOpenPanel *panel = [[NSOpenPanel openPanel] retain];
	
	[panel beginForDirectory:nil file:nil types:fileTypes modelessDelegate:self didEndSelector:@selector(openPanelDidEnd:returnCode:contextInfo:) contextInfo:NULL];
}

- (IBAction)drawArcs:(id)sender
{
	NSString *inputString = nil; 
	
	if (selectedInputTabViewItem == directInputTabViewItem)
	{
		if ([[directInputTextView string] length] != 0)
		{
			inputString = [directInputTextView string];
		}
	}
	else if (selectedInputTabViewItem == fileInputTabViewItem)
	{
		if (filePath)
		{
			inputString = [NSString stringWithContentsOfFile:filePath];
		}
	}
	
	if (inputString)
	{
		//remove EOLs!
		NSString *temp = [[NSString alloc] init];
		NSMutableString *temp2 = [NSMutableString string];
		NSScanner *nlScanner = [NSScanner scannerWithString:inputString];
		while (![nlScanner isAtEnd])
		{
			[nlScanner scanUpToString:@"\n" intoString:&temp];
			[temp2 appendString:temp];
		}
		inputString = temp2;

		//remove whitespace
		if ([ignoreWhitespaceButton state] == NSOnState)
		{
			NSString *temp = [[NSString alloc] init];
			NSMutableString *temp2 = [NSMutableString string];
			NSScanner *whiteScanner = [NSScanner scannerWithString:inputString];
			while (![whiteScanner isAtEnd])
			{
				[whiteScanner scanUpToCharactersFromSet:[NSCharacterSet whitespaceCharacterSet] intoString:&temp];
				[temp2 appendString:temp];
			}
			inputString = temp2;
		}
		//ignore case
		if ([ignoreCaseButton state] == NSOnState)
		{
			inputString = [inputString lowercaseString];
		}
		
		[appController drawArcsWithString:inputString andMinimalRepetitionLength:[minimumRepetitionLengthSlider intValue]];
	}
}

- (void)animateProgressIndicator
{
	[progressIndicator startAnimation:self];
}

- (void)stopProgressIndicator
{
	[progressIndicator stopAnimation:self];
}

- (IBAction)setMinimumRepetitionLengthString:(id)sender
{
	NSString *value = [NSString stringWithFormat:@"min. repetition size: %i", [minimumRepetitionLengthSlider intValue]];
	[minimumRepetitionLengthValue setStringValue:value];
}

- (void)tabView:(NSTabView *)tabView willSelectTabViewItem:(NSTabViewItem *)tabViewItem
{
	selectedInputTabViewItem = tabViewItem;
	
	/*
	//NSRect tabViewItemBounds = [[tabViewItem view] bounds];
	NSRect windowBounds = [[self window] frame];
	//NSRect currentTabViewItemBounds = [tabView]
	
	NSRect newWindowBounds = NSMakeRect(windowBounds.origin.x, windowBounds.origin.y, windowBounds.size.width, windowBounds.size.height - 20);
	
	[[self window] setFrame:newWindowBounds display:YES animate:YES];
	*/
}


@end
