//
//  InputPanelController.h
//  guiTest
//
//  Created by David Palme on 22.05.07.
//  Copyright 2007 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import "AppController.h"

/*!
	@class InputPanelController
	@abstract gui controller class for the input panel.
*/

@interface InputPanelController : NSWindowController
{
	IBOutlet NSTabView *inputTabView;
	NSTabViewItem *directInputTabViewItem;
	NSTabViewItem *fileInputTabItem;
	NSTabViewItem *selectedInputTabViewItem;

	IBOutlet NSTextView *directInputTextView;
	
	IBOutlet NSButton *chooseFileButton;
	IBOutlet NSTextField *inputFileName;
	NSString *filePath;

	IBOutlet NSButton *ignoreWhitespaceButton;
	IBOutlet NSButton *ignoreCaseButton;
	IBOutlet NSSlider *minimumRepetitionLengthSlider;
	IBOutlet NSTextField *minimumRepetitionLengthValue;
	IBOutlet NSProgressIndicator *progressIndicator;
	IBOutlet NSButton *drawArcsButton;
}

//overritten methods

//delegate methods
- (void)awakeFromNib;
- (void)tabView:(NSTabView *)tabView willSelectTabViewItem:(NSTabViewItem *)tabViewItem;
- (void)openPanelDidEnd:(NSOpenPanel *)openPanel returnCode:(int)returnCode contextInfo:(void *)x;

//own implementation

/*!
	@method initWithAppController:
	@abstract initialises a new input panel controller with a given appcontroller.
*/
- (id)initWithAppController:(id)aAppController;

/*!
	@method open:
	@abstract IBAction that shows 'open file' sheet and opens the selected file.
*/
- (IBAction)open:(id)sender;

/*!
	@method drawArcs:
	@abstract IBActionthat tells appcontroller to do everything needed to draw the arcs for the input string. 
*/
- (IBAction)drawArcs:(id)sender;

- (void)animateProgressIndicator;
- (void)stopProgressIndicator;

/*!
	@method setMinimumRepetitionLengthString:
	@abstract IBAction that sets the minimum repetition length and updates the gui.
*/
- (IBAction)setMinimumRepetitionLengthString:(id)sender;

@end
