//
//  ArcDiagramView.m
//  guiTest
//
//  Created by David Palme on 29.05.07.
//  Copyright 2007 __MyCompanyName__. All rights reserved.
//

#import "ArcDiagramView.h"

NSMutableSet *arcs;
NSAttributedString *superString;
NSRect superStringRect;

NSPoint grabOrigin;
NSPoint scrollOrigin;

@implementation ArcDiagramView

- (id)initWithFrame:(NSRect)frame
{
	NSLog(@"inititalising ArcDiagramView.");

	//dev...
	//frame = NSMakeRect(0, 0, 500, 400);
	//dev...

    self = [super initWithFrame:frame];
    if (self)
	{
        arcs = nil;
	}
	
    return self;
}

- (void)drawRect:(NSRect)rect
{
	NSEnumerator *arcEnumerator;

	NSRect bounds = [self bounds];
	
	[[NSColor brownColor] set];
	[NSBezierPath fillRect:bounds];
	
	//dev...
	//[self scaleUnitSquareToSize:NSMakeSize(1.1, 1.1)];
	//[self setBoundsSize:NSMakeSize(800, 800)];
	
	NSSize superStringSize = [superString size];
	float scaleFactorHeight = (bounds.size.height - 50) / superStringSize.height;
	float scaleFactorWidth = (bounds.size.width) / superStringSize.width;
	float scaleFactor;
	
	if (scaleFactorWidth <= scaleFactorHeight)
	{
		scaleFactor = scaleFactorWidth;
	}
	else
	{
		scaleFactor = scaleFactorHeight;
	}
	
	//NSLog(@"+ padding +");
	//NSLog(@"width : %f", (bounds.size.width * scaleFactor));
	//NSLog(@"string: %f", (superStringSize.width * scaleFactor));
	//NSLog(@"paddin: %f", padding);
	
	
	//scale to fit into view
	[NSGraphicsContext saveGraphicsState];
	
	NSAffineTransform *viewTransformation = [NSAffineTransform transform];
	[viewTransformation scaleBy:scaleFactor];
	[viewTransformation translateXBy:0 yBy:0];
	[viewTransformation concat];
	
	//[NSGraphicsContext restoreGraphicsState];
	//[NSGraphicsContext saveGraphicsState];
	
	/*
	NSAffineTransform *arcTranslation = [NSAffineTransform transform];
	float x = (bounds.size.width - superStringSize.width) / 2;
	[arcTranslation translateXBy:x yBy:0];
	[arcTranslation concat];
	*/
	
	[superString drawAtPoint:NSMakePoint(0, 0)];
	
	//draw arcs
	if (arcs)
	{
		arcEnumerator = [arcs objectEnumerator];
		
		NSBezierPath *currentPath;
		
		[[[NSColor whiteColor] colorWithAlphaComponent:0.5] set];
		
		while (currentPath = [arcEnumerator nextObject])
		{
			[currentPath stroke];
		}
	}
}

- (void)drawSuperStringCenteredIn:(NSRect)rect
{
	NSPoint stringOrigin;
	NSSize stringSize;
	
	//stringSize == ...
	stringOrigin.x = rect.origin.x + (rect.size.width - stringSize.width) / 2;
	stringOrigin.y = rect.origin.y + (rect.size.height - stringSize.height) / 2;
	
	[superString drawAtPoint:stringOrigin];
}

- (void)mouseDown:(NSEvent *)event
{
	unsigned int flags = [event modifierFlags];
	
	if (flags & NSAlternateKeyMask)
	{
		grabOrigin = [event locationInWindow];

		NSClipView *contentView;
		contentView = (NSClipView *)[self superview];

		scrollOrigin = [contentView bounds].origin;
	}
}


- (void)mouseDragged:(NSEvent *)event
{
	unsigned int flags = [event modifierFlags];
	
	//drag-scrolling
	if (flags & NSAlternateKeyMask)
	{
		NSPoint mousePoint;
		mousePoint = [event locationInWindow];

		float deltaX, deltaY;
		deltaX = grabOrigin.x - mousePoint.x;
		deltaY = mousePoint.y - grabOrigin.y;

		NSPoint newOrigin;
		newOrigin = NSMakePoint(scrollOrigin.x + deltaX, scrollOrigin.y - deltaY);

		[self scrollPoint: newOrigin];
	}
	//zooming doesnt get event yet
	else
	{
		NSLog(@"zoom: %f", [event deltaZ]);
	}
}


- (void)keyDown:(NSEvent *)event
{
	NSLog(@"%i", [event keyCode]);
	
	/*
	unsigned int flags = [event modifierFlags];
	
	if (flags & NSAlternateKeyMask)
	{
		NSLog(@"hand.");
	}
	*/
}

- (void)setSuperString:(NSAttributedString *)aString
{
	[aString retain];
	superString = aString;
}

- (void)setArcsWithSet:(NSMutableSet *)aSet
{
	NSLog(@"arcs in arcDiagramView set.");
	[aSet retain];
	
	arcs = aSet;
	[self setNeedsDisplay:YES];
}

@end
