//
//  ArcDiagramController.m
//  Arcs
//
//  Created by the cell on 6/10/07.
//  Copyright 2007 __MyCompanyName__. All rights reserved.
//

#import "ArcDiagramController.h"


ArcDiagramView *arcDiagramView;
NSString *superString;
NSRect superStringRect;
NSArray *essentialMatchingPairs;
NSArray *arcs;
NSMutableSet *arcDiagrams;

NSMutableDictionary *attributes;

@implementation ArcDiagramController

- (id)initWithView:(ArcDiagramView *)aArcDiagramView
{
	self = [super init];
	
	if (self)
	{
		[aArcDiagramView retain];
		arcDiagramView = aArcDiagramView;
	}
	
	[self prepareSuperStringAttributes];
	
	NSLog(@"inititalising ArcDiagramController.");
	
	return self;
}

- (void)setEssentialMatchingPairs:(NSArray *)someEssentialMatchingPairs;
{
	[someEssentialMatchingPairs retain];
	essentialMatchingPairs = someEssentialMatchingPairs;
}

- (void)setSuperString:(NSString *)aString
{
	[aString retain];
	superString = aString;
}

- (void)prepareSuperStringAttributes
{
	attributes = [[NSMutableDictionary alloc] init];
	[attributes setObject:[NSColor whiteColor] forKey:NSForegroundColorAttributeName];
	[attributes setObject:[NSFont fontWithName:@"Courier Bold" size:75] forKey:NSFontAttributeName];
}

- (void)calculateArcs
{
	NSLog(@"calculation arcs...");
	
	arcDiagrams = [NSMutableSet set];
	NSSize characterSize = [[NSString stringWithString:@"x"] sizeWithAttributes:attributes];
	
	//that arcs are closer to the string
	float arcHeight = characterSize.height - 20;
	
	Arc *a;
	int outerIndex = 0;
	int innerIndex = 0;
	float aCenterX;
	
	for (outerIndex; outerIndex < [essentialMatchingPairs count]; outerIndex++)
	{
		innerIndex = 0;
		for (innerIndex; innerIndex < [[essentialMatchingPairs objectAtIndex:outerIndex] count]; innerIndex++)
		{
			a = [[Arc alloc] initWithMatchingPair:[[essentialMatchingPairs objectAtIndex:outerIndex] objectAtIndex:innerIndex]];
			aCenterX = [a centerIndex] * characterSize.width;
			[a calculateArcRepresentationWithCharacterSize:characterSize inCenter:NSMakePoint(aCenterX, arcHeight)];
			
			[arcDiagrams addObject:[a arcRepresentationPath]];
		}
	}
}

- (void)renderView
{
	[arcDiagramView setSuperString:[[NSAttributedString alloc] initWithString:superString attributes:attributes]];
	
	[self calculateArcs];
	[arcDiagramView setArcsWithSet:arcDiagrams];
	[arcDiagramView setNeedsDisplay:YES];
}

- (void)dealloc
{
	[arcDiagramView release];
	[superString release];
	[essentialMatchingPairs release];
	
	[super dealloc];
}


@end
