//
//  Arc.m
//  guiTest
//
//  Created by David Palme on 28.05.07.
//  Copyright 2007 __MyCompanyName__. All rights reserved.
//

#import "Arc.h"


MatchingPair *matchingPair;
NSBezierPath *arcRepresentationPath = nil;

@implementation Arc

- (id)initWithMatchingPair:(MatchingPair *)aMatchingPair
{
	self = [super init];
	
	if (self)
	{
		[aMatchingPair retain];
		matchingPair = aMatchingPair;
	}
	
	return self;
}

- (int)thicknes
{
	return [matchingPair stringLength];
}

- (int)innerRadius
{
	return [matchingPair distanceBetweenStrings];
}

- (int)outerRadius
{
	return [matchingPair length];
}

- (float)centerIndex
{
	float length = [matchingPair length]; 
	return [matchingPair firstLocation] + (length / 2);
}

- (void)calculateArcRepresentationWithCharacterSize:(NSSize)characterSize inCenter:(NSPoint)aCenter
{
	arcRepresentationPath = [[NSBezierPath alloc] init];
	
	float matchingPairLength = [matchingPair length];
	float distanceBetweenStrings = [matchingPair distanceBetweenStrings];
	float stringLength = [matchingPair stringLength];
	float smallRadius = (distanceBetweenStrings / 2) + (stringLength / 2);
	
	[arcRepresentationPath appendBezierPathWithArcWithCenter:aCenter radius:(smallRadius * characterSize.width)  startAngle:0 endAngle:180];

	//we make it a litte thinner that you can see the borders
	[arcRepresentationPath setLineWidth:(characterSize.width * [matchingPair stringLength] - 2)];
}

- (NSBezierPath *)arcRepresentationPath
{
	if (!arcRepresentationPath)
	{
		NSLog(@"arc diagram has not been calculated yet.");
	}
	
	return arcRepresentationPath;
}

@end
