//
//  Arc.h
//  guiTest
//
//  Created by David Palme on 28.05.07.
//  Copyright 2007 __MyCompanyName__. All rights reserved.
//
#ifndef H_ARC
#define H_ARC

#import <Cocoa/Cocoa.h>

#import "MatchingPair.h"

/*!
	@class Arc
	@abstract class for an arc for a certain matching pair.
*/

@interface Arc : NSObject
{
	MatchingPair *matchingPair;
	NSBezierPath *arcRepresentationPath;
}

/*!
	@method initWithMatchingPair:
	@abstract initialises a new arc with a given matching pair.
*/
- (id)initWithMatchingPair:(MatchingPair *)aMatchingPair;

/*!
	@method thicknes
	@abstract returns the arc's thicknes.
*/
- (int)thicknes;

/*!
	@method innerRadius
	@abstract returns the arc's inner radius.
*/
- (int)innerRadius;

/*!
	@method outerRadius
	@abstract returns the arc's outer radius.
*/
- (int)outerRadius;

/*!
	@method centerIndex
	@abstract returns the center character position of the arcs matching pair. this can be also half a character (e.g. 3.5).
*/
- (float)centerIndex;

/*!
	@method calculateArcRepresentationWithCharacterSize:inCenter:
	@abstract calculates the arc diagram for this arc.
*/
- (void)calculateArcRepresentationWithCharacterSize:(NSSize)size inCenter:(NSPoint)aCenter;

/*!
	@method arcRepresentationPath
	@abstract if the diagram has been calculated the representing NSBezierPath will be returned.
*/
- (NSBezierPath *)arcRepresentationPath;

@end

#endif