#import "AppController.h"

IBOutlet NSMenuItem *menuItemInputPanel;

IBOutlet NFHUDWindow *arcInspectorHUDPanel;
NSWindowController *inputPanelController;

IBOutlet NSWindow *arcDiagramWindow;
IBOutlet ArcDiagramView *arcDiagramView;

RepetitionFinder *repetitionFinder;
ArcDiagramController *arcDiagramController;

@implementation AppController

- (void)awakeFromNib
{
	inputPanelController = [[InputPanelController alloc] initWithAppController:self];
	[inputPanelController showWindow:self];

	arcDiagramController = [[ArcDiagramController alloc] initWithView:arcDiagramView];
	
	/*
	if (![arcDiagramWindow isKeyWindow])
	{
		[arcDiagramWindow makeKeyAndOrderFront:self];
	}
	*/
	
	repetitionFinder = [[RepetitionFinder alloc] init];
}

- (void)drawArcsWithString:(NSString *)aString andMinimalRepetitionLength:(int)minimalLength
{
	NSLog(@"processing string: %@ for minimal repetition length: %i", aString, minimalLength);
	
	[inputPanelController animateProgressIndicator];
	
	[repetitionFinder prepareWithString:aString];
	NSArray *essentialMatchingPairs = [repetitionFinder essentialMatchingPairsWithMinimalRepetitionLength:minimalLength];
	
	[arcDiagramController setSuperString:aString];
	[arcDiagramController setEssentialMatchingPairs:essentialMatchingPairs];
	[arcDiagramController renderView];
	
	[inputPanelController stopProgressIndicator];
}

- (IBAction)showInputPanel:(id)sender
{
	[inputPanelController showWindow:self];
}

- (IBAction)open:(id)sender
{
	[inputPanelController open:sender];
}

- (void)dealloc
{
	[inputPanelController release];
	[super dealloc];
}

@end
