package interring;
/** Lister der Ringdicken
 * Diese Liste beinhaltet die Dicke der Ringe fr jede Schicht.
 * Diese Klasse wurde zur Kapselung gewhlt, um auch Funktionen fr Verzerrung
 * zu implementieren. Somit dient diese Klasse, einerseits der Speicherung der Dicken
 * und auch der Modifikation dieser.
 * @author Thomas Kment
 * @author Christof Kier
 */
public class ThicknessList {
	private double thickness[]; // Liste der Rindicken
	private double default_thickness; // Defaultwert
	private double minimum_thickness; // Minimum
	
	/** Konstruktor
	 * 
	 * @param size - Anzahl Schichten
	 * @param default_thickness - Defaultdicke
	 * @param minimum_thickness - Minimumdicke
	 */
	public ThicknessList(int size, double default_thickness, double minimum_thickness){
		this.thickness = new double[size];
		this.default_thickness = default_thickness;
		this.minimum_thickness = minimum_thickness;
		for(int i = 0; i < size; i++) this.thickness[i] = this.default_thickness;
	}
	
	/** Methode zur Berechnung Radius einer Schicht
	 * 
	 * @param distance2root - Schicht
	 * @return Radius einer Schicht
	 */
	public double getRadius(int distance2root){
		double ret = default_thickness;
		if(distance2root > -1 && distance2root < thickness.length){
			for(int i = 0; i < distance2root; i++){
				ret = ret + thickness[i];
			}
		}
		return ret;
	}
	
	/** Methode, um aus Radius auf eine Schicht rckzurechnen
	 * 
	 * @param distance
	 * @return
	 */
	public int getLayer(double distance){
		if(distance > default_thickness){
			double cumul = default_thickness;
			int i = 0;
			boolean success = false;
			for(i = 0; i < thickness.length; i++){
				if(distance > cumul && distance < cumul + thickness[i]){
					success = true;
					break;					
				}	
				cumul += thickness[i];
			}	
			if(success) return i;
			else return -1;
		}
		else if(distance > 0.0){
			return 0;
		}
		else return -1;
	}
	
	/** Methode zur Kantenauswahl
	 * Diese Methode bestimmt, ob die innere Kante eines Rings ausgwhlt wurde.
	 * @param layer - Schicht
	 * @param distance - Radius
	 * @return true, wenn innere Kante ausgewhlt
	 */
	public boolean isInnerBorder(int layer, double distance){
		double dist = getRadius(layer);
		dist = dist + (thickness[layer] / 2.0);
		if(distance < dist) return true;
		else return false;
	}
	
	/** Methode zur Verzerrung
	 * 
	 * @param layer - Schicht 
	 * @param amount - Verzerrung
	 * @param direction - Richtung (nach innen/auen)
	 */
	public void modify(int layer, double amount, boolean direction){
		amount = amount / 10.0;
		
		if(direction){ // nach innen	
			double minimum = (double) layer * this.minimum_thickness + this.default_thickness;
			double maximum = (double) layer * this.default_thickness + this.default_thickness;
			double actual = this.getRadius(layer);
			double newsize = actual - amount;
			if(newsize > minimum && newsize < maximum){
				thickness[layer] = thickness[layer] + amount;
				if(thickness[layer] < 0.0) thickness[layer] = 0.0;
				for(int i = 0; i < layer; i++){
					thickness[i] = thickness[i] - amount / layer;					
				}
			}
		}else{
			if(layer < thickness.length){
				double minimum = ((double)layer+1.0) * this.default_thickness + this.default_thickness;
				double maximum = ((double)thickness.length) * this.default_thickness + this.default_thickness;
				double actual = this.getRadius(layer+1);
				amount = -amount;
				double newsize = actual + amount;
				if(newsize > minimum && newsize < maximum){
					thickness[layer] = thickness[layer] + amount;
					if(thickness[layer] < 0.0) thickness[layer] = 0.0;
					for(int i = layer+1; i < thickness.length; i++){
						thickness[i] = thickness[i] - amount / (thickness.length - layer);						
					}
				}
			}
		}
	}
}
