package interring;
/** Klasse, welche Verzeichnisbaum darstellt
 * 
 * @author Thomas Kment
 * @author Christof Kier
 */
import java.util.Vector;

public class InterringNode {
	private String name; // Verzeichnis/Dateiname
	private long size; // gre (0 bei Verzeichnis)
	public Vector<InterringNode> children; // "Kinder"
	
	/** Konstruktor
	 * 
	 *
	 */
	public InterringNode(){
		name = null;
		size = 0;
		children = new Vector<InterringNode>();
	}

	/** Konstruktor
	 * 
	 * @param name - Name
	 * @param size - Gre
	 */
	public InterringNode(String name, long size){
		this.name = name;
		this.size = size;
		children = new Vector<InterringNode>();
	}	
	
	/** Methode um Kinder hinzufgen (statisch)
	 * 
	 * @param node
	 * @param nodes
	 */
    public static void addChildren(InterringNode node, InterringNode[] nodes) {
        for (InterringNode element : nodes) {
            node.children.add(element);
        }
    }
    
    /** Methode um Kinder hinzuzufgen
     * 
     * @param node
     */
    public void addChild(InterringNode node) {
       children.add(node);       
    }
	
    /** Methode um Festzustellen ob Node ein Blatt ist
     *  
     * @return True, wenn Node ein Blatt ist
     */
    public boolean isleaf(){
    	return this.getChildCount() == 0;
    }
    
    /** Methode um Gre des aufgespannten Subbaums zu ermitteln
     * 
     * @return Gre
     */
    public long getBranchSize(){
	   long cum_size = size;
	   //if(min && size < 100) cum_size = 100; // Mindestgre
	   if(getChildCount() > 0) {
		   cum_size = 0; // Damit Ordner grenneutral bleiben
		   for(int i = 0; i< children.size();i++){
			   cum_size += children.get(i).getBranchSize();
		   }
	   }
	   return cum_size;
    }    
   
    public long getFileCount(){
    	long count = 0;
    	if(getChildCount() > 0) { 		
 		   for(int i = 0; i< children.size();i++){
 			   count += children.get(i).getFileCount();
 		   }
 		} else count = 1;
    	return count;    
    }    
  
    // setter und getter
    
	public String getName() {		return name;	}
	
	public long getSize() 	{		return size;	}
	
	public void setName(String name) 	{		this.name = name;	}
	
	public void setSize(long size) 		{		this.size = size;	}

	public int getChildCount() { return children.size(); }
	
    public InterringNode getChildAt(int i) {
        return (InterringNode)children.elementAt(i);
    }
    
    public int getIndexOfChild(InterringNode node) {
        return children.indexOf(node);
    }	
}
