package interring;
/** Klasse fr Geometrie des Interrings
 * 
 * @author Thomas Kment
 * @author Christof Kier
 */
import java.awt.Graphics2D;
import java.awt.geom.*;
import java.awt.Stroke;
import java.awt.BasicStroke;
import java.awt.GradientPaint;
import java.awt.Color;

import java.awt.geom.AffineTransform;
import java.util.Vector;

public class GeometryNode{
	public Vector<GeometryNode> children;
	private String name; // Objektname
	private long size;		// Gre
	private double alpha; //min = 0.0
	private double omega; //max = 360.0
	private int distance2root; // fr root = 0
	private boolean visible; // sichtbar?
	private boolean children_visible; // kinder sichtbar?
	private boolean selected; // ausgewhlt?
	
	/** Konstruktor
	 * 
	 *
	 */
	public GeometryNode(){
		visible = true;
		name = null;
		size = 0;
		alpha = 0.0;
		omega = 360.0;
		distance2root = 0;
		children = new Vector<GeometryNode>();
		children_visible = true;		
		selected = false;
	}
	
	/** Konstruktor
	 * 
	 *
	 */
	public GeometryNode(double alpha, int distance2root, String name, long size, double omega){
		visible = true;
		this.name = name;
		this.size = size;
		this.alpha = alpha;
		this.omega = omega;
		this.distance2root = distance2root;
		children = new Vector<GeometryNode>();
		children_visible = true;
		selected = false;
	}

	/** Konstruktor
	 * 
	 *
	 */
	public GeometryNode(String name, long size){
		visible = true;
		this.name = name;
		this.size = size;
		children = new Vector<GeometryNode>();
		alpha = 0.0;
		omega = 0.0;
		distance2root = 0;
	}	
	
	/** Statische Methode um Kinder hinzuzufgen
	 * 
	 * @param node - Vater
	 * @param nodes - neue Kinder
	 */
    public static void addChildren(GeometryNode node, GeometryNode[] nodes) {
        for (GeometryNode element : nodes) {
            node.children.add(element);
        }
    }
    
    /** Methode um Kinder hinzuzufgen
     * 
     * @param node - neues Kind
     */
    public void addChild(GeometryNode node) {
       children.add(node);       
    }
	
    /** Methode, um festzustellen, ob Node ein Blatt ist
     * 
     * @return true, wenn er ein Blatt ist
     */
    public boolean isleaf(){
    	return this.getChildCount() == 0;
    }
    
    /** Methode um Gre Subbaum festzustellen.
     * 
     * @return Gre Subbaum
     */
   public long getBranchSize(){
	   long cum_size = size;
	   if(getChildCount() > 0) {
		   for(int i = 0; i< children.size();i++){
			   cum_size += children.get(i).getBranchSize();
		   }
	   }
	   return cum_size;
   }    
   
   /** Methode, um Auswahl aller Nodes aufzuheben
    * 
    *
    */
   public void clearAllSelections(){
	   this.selected = false;
	   if(getChildCount() > 0) {
		   for(int i = 0; i< children.size();i++){
			   children.get(i).clearAllSelections();
		   }
	   }
   }
   
   /** Methode fr Picking
    * 
    * @param distance2root - Tiefe im Baum
    * @param angle - Winkel
    * @return ausgewhlter Knoten
    */
   public GeometryNode search(int distance2root, double angle){
	   GeometryNode ret = null;	   
	   if(this.distance2root == distance2root){
		   if(this.alpha < angle && this.omega > angle) ret = this;
	   } else{
		   if(getChildCount() > 0) {
			   for(int i = 0; i< children.size();i++){
				 GeometryNode candidate = children.get(i).search(distance2root, angle);
				 if(candidate != null) ret = candidate;
			   }
		   }
	   }   
	   return ret;
   }
	
   // getter / setter 
   
	public String getName() {		return name;	}
	
	public long getSize() 	{		return size;	}
	
	public void setName(String name) 	{		this.name = name;	}
	
	public void setSize(long size) 		{		this.size = size;	}

	public int getChildCount() { return children.size(); }
	
    public GeometryNode getChildAt(int i) {
        return (GeometryNode)children.elementAt(i);
    }
    
    public int getIndexOfChild(GeometryNode node) {
        return children.indexOf(node);
    }

	public double getAlpha() {		return alpha;	}

	public int getDistance2root() {		return distance2root;	}

	public double getOmega() {		return omega;	}

	public void setAlpha(double alpha) {		this.alpha = alpha;	}

	public void setDistance2root(int distance2root) {		this.distance2root = distance2root;	}

	public void setOmega(double omega) {		this.omega = omega;	}
	
	/** Methode fr Ermittlung max. Baumtiefe
	 * 
	 * @return max. Baumtiefe
	 */
	public int getMaxDepth(){
	   int ret = this.distance2root;
	   if (getChildCount() > 0) {
		   for(int i = 0; i< children.size();i++){
			   int can = children.get(i).getMaxDepth();
			   if(can > ret) ret = can;
		  }
	   }	    
	   return ret;
	}
	
	/** Methode zur Erechnung Farbe eines Ringsegments
	 * Diese Methode folgt dem Middle-Color Asignment und 
	 * verwendet den mittleren Winkel, um in einem Farbverlauf
	 * eine Farbe auszuwhlen 
	 * @param angle - Winkel
	 * @return Farbe
	 */
	private Color getColor(double angle){
		float r = 0.0f;
		float g = 0.0f;
		float b = 0.0f;
		
		if(angle >= 0.0 && angle < 120.0){
			r = - (float)angle / 120.0f + 1.0f;
			if(r < 0.0f) r = 0.0f;
			g = (float)angle / 120.0f;
			if(g > 1.0f) g = 1.0f;
		}else if(angle >= 120.0 && angle < 240){
			g = -((float)angle - 120.0f)/120.0f + 1.0f;
			if(g < 0.0f) g = 0.0f;
			b = ((float)angle - 120.0f)/120.0f;
			if(b > 1.0f) b = 1.0f;
		}else if(angle >= 240.0 && angle <= 360){
			b = -((float)angle - 240.0f)/120.0f + 1.0f;
			if(b < 0.0f) b = 0.0f;
			r = ((float)angle - 240.0f)/120.0f;
			if(r > 1.0f) r = 1.0f;
		}
		float brightness = 0.20f;
		r+=brightness;
		g+=brightness;
		b+=brightness;
		if(r > 1.0f) r = 1.0f;
		if(g > 1.0f) g = 1.0f;
		if(b > 1.0f) b = 1.0f;
		
		return new Color(r,g,b);
	}
	
	public void setVisibility(boolean visible){
		this.visible = visible;
	}
	
	public boolean getVisibility(){
		return visible;
	}
	
	public void toggleVisibilityOfChildren(){
		 if(this.getChildCount()>0){
			 for(int i = 0; i< children.size();i++){
				   children.get(i).setVisibility(!children.get(i).getVisibility());
			   }		
			 children_visible = !children_visible;
		 }
	}
	
	public void enableSelection(){		
		this.selected = true;
	}
	
	/** Zeichenfunktion - rekursiv!
	 *  
	 * @param tlist - ThicknessList
	 * @param at - Matrix mit Transformationen
	 * @param g2 - Graphics2D Instanz
	 */
	public void drawIt(ThicknessList tlist, AffineTransform at, Graphics2D g2){
		 if(visible){	 
			 double outer = tlist.getRadius(distance2root + 1);
			 // Tortensegment
			 Arc2D segment = new Arc2D.Double(0.0 - outer,
					 0.0 - outer,
	                 2.0 * outer,
	                 2.0 * outer,
	                 alpha, omega - alpha,
	                 Arc2D.PIE);
			 
			 // Kreis
			 double inner = tlist.getRadius(distance2root);
			
			 Ellipse2D whitespace = new Ellipse2D.Double(	0.0 - inner,
						 									0.0 - inner,
						 									2.0 * inner,
						 									2.0 * inner);
			 // Abzug des Kreise vom Tortensegment
			 Area areaSegment = new Area(segment);
			 Area areaWhitespace = new Area(whitespace);
			 areaSegment.subtract(areaWhitespace);	 	 	
			 // Fllung
			 g2.setPaint(this.getColor((alpha+omega)/2));
			 g2.fill(at.createTransformedShape(areaSegment));
			 // Zeichnen des Randes
			 g2.setPaint(Color.BLACK);
			 g2.draw(at.createTransformedShape(areaSegment));		 
			 // Sonderfall fr Root
			 if(distance2root == 0){
				 g2.setPaint(this.getColor((alpha+omega)/2));
				 g2.fill(at.createTransformedShape(areaSegment));				 	 
			 }
			 // selbes fr Kinder
			 if(this.getChildCount()>0){				 
				 for(int i = 0; i< children.size();i++){
					   children.get(i).drawIt(tlist, at, g2);
				 }		
				 // Hint, falls Kinder verdeckt sind
				 if(!children_visible){	
					 Stroke temp = g2.getStroke();
					 BasicStroke stroke = new BasicStroke(5.0f, BasicStroke.CAP_SQUARE, BasicStroke.JOIN_BEVEL);
					 g2.setStroke(stroke);
					 g2.setPaint(Color.WHITE);
					 double a = alpha;
					 double o = omega;
					 if(omega - alpha > 5.0)     {
						 a = alpha + 1.5;
						 o = omega - 1.5;
					 }
					 double diff = Math.round(inner + ((outer - inner) / 2.0));
					 Arc2D segment2 = new Arc2D.Double(0.0 - diff,
							 0.0 - diff,
			                 2.0 * diff,
			                 2.0 * diff,
			                 a, o - a,
			                 Arc2D.OPEN);
					 g2.draw(at.createTransformedShape(segment2));		
					 g2.setStroke(temp);
				 }
				 // Auswahlrahmen, falls dieser gebraucht wird
				 if(selected){					 
					 double outer2 = outer - 1.0;
					 double a = alpha;
					 double o = omega;
					 if(omega - alpha > 5.0 && omega - alpha < 360.0)     {
						 a = alpha + 1.5;
						 o = omega - 1.5;
					 }
					 Arc2D segment2 = new Arc2D.Double(0.0 - outer2,
							 0.0 - outer2,
			                 2.0 * outer2,
			                 2.0 * outer2,
			                 a, o - a,
			                 Arc2D.PIE);
					 
					 double inner2 = inner + 1.0;
					
					 Ellipse2D whitespace2 = new Ellipse2D.Double(	0.0 - inner2,
								 									0.0 - inner2,
								 									2.0 * inner2,
								 									2.0 * inner2);

					 Area areaSegment2 = new Area(segment2);
					 Area areaWhitespace2 = new Area(whitespace2);
					 areaSegment2.subtract(areaWhitespace2);						
					 Stroke temp = g2.getStroke();
					 BasicStroke stroke = new BasicStroke(3.0f, BasicStroke.CAP_SQUARE, BasicStroke.JOIN_BEVEL);
					 g2.setStroke(stroke);
					 g2.setPaint(Color.WHITE);					 
					 g2.draw(at.createTransformedShape(areaSegment2));
					 g2.setStroke(temp);
				 }
			 }
		 }
	}
}
