package interring;
/** 
 * @author Thomas Kment
 * @author Christof Kier
 */
import javax.swing.*;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.io.File;
import java.awt.Dimension;

/** Navigationsfenster 
 * Dieses Fenster beinhaltet alle Funktionalitt zum laden von Datenstzen
 * oder Schlieen des Programms.
 * Modus 1 in diesem Kontext bedeutet, dass der Interring aufgebaut wird
 * aus Verzeichnissen und Dateien. Dabei wird jedes Element einzeln dargstellt.
 * Modus 2 unterscheidet sich davon, da hier alle Dateien auf einer Ebene
 * eines Knotens in ein Element zusammengefasst werden und damit die 
 * Darstellungsleistung zu erhhen.
 * @author Thomas Kment
 * @author Christof Kier
 */
public class GUI_MainWindow extends JFrame implements ActionListener{
	private JMenuItem mi_file; // Men Eintrag Daten Laden - Modus 1
	private JMenuItem mi_file2;// Men Eintrag Daten Laden - Modus 2
	private JMenuItem mi_output;// Men Eintag Ausgabefenster anzeigen
	private JMenuItem mi_exit; // Men Eintag Programm schlieen
	private JFileChooser fc_file;	// Dateiauswahldialog
	private InterringNode rootnode; // Wurzelknoten der Dateistruktur
	private GUI_Output output; // Instanz Ausgabefenster
	
	/** Actionhandler
	 * Diese Methode verarbeitet aufkommende GUI-Events
	 */
	public void actionPerformed(ActionEvent e) {
		// Button fr Mode 1
		if(e.getSource() == mi_file) {			
			int returnVal = fc_file.showOpenDialog(this);
			if(returnVal == JFileChooser.APPROVE_OPTION){
				rootnode = this.addNodes(null, fc_file.getSelectedFile());				
				output.setGeometry(rootnode);
				if(!output.isVisible()) output.setVisible(true);
			}
		}
		// Button fr Mode 2
		if(e.getSource() == mi_file2) {			
			int returnVal = fc_file.showOpenDialog(this);
			if(returnVal == JFileChooser.APPROVE_OPTION){
				rootnode = this.addNodes2(null, fc_file.getSelectedFile());				
				output.setGeometry(rootnode);
				if(!output.isVisible()) output.setVisible(true);
			}
		}
		// Button fr Exit
		if(e.getSource() == mi_exit){
			output.dispose();
			dispose();
		}		
		// Button fr Outputfenster anzeigen
		if(e.getSource() == mi_output){
			if(!output.isVisible()) output.setVisible(true);
		}
	}	
	
	/** Methode zum Durchlauf der Verzeichnisstruktur Modus 1
	 * Diese Methode ist rekursiv gestaltet. Sie durchluft von 
	 * einem Ausgangsverzeichnis ausgehend einen Verzeichnisbaum
	 * und bildet dessen Struktur rekursiv in der Klasse InterringNode 
	 * ab.
	 * @param curTop "Vaterknoten"
	 * @param dir Verzeichnis
	 * @return fertigen Knoten
	 */
	private InterringNode addNodes(InterringNode curTop, File dir) {		
		InterringNode curDir = new InterringNode(dir.getPath(),0);
		if (curTop != null) { // should only be null at root
			curTop.addChild(curDir);
		}
		File[] files = dir.listFiles();		
		// Array durchlaufen
		// - bei Verzeichnis: rekusiver Aufruf dieser Methode
		// - bei Datei: hinzufgen zu akuteller Node
		for(int i = 0; i < files.length; i++){			
			if(files[i].isDirectory()){								
				addNodes(curDir, files[i]);
			} else{
				InterringNode node = new InterringNode(files[i].toString(),files[i].length());							
				curDir.addChild(node);		
			}		
		}		
		return curDir;
	}	

	/** Methode zum Durchlauf der Verzeichnisstruktur Modus 2
	 * Diese Methode ist rekursiv gestaltet. Sie durchluft von 
	 * einem Ausgangsverzeichnis ausgehend einen Verzeichnisbaum
	 * und bildet dessen Struktur rekursiv in der Klasse InterringNode 
	 * ab.
	 * Diese Methode fast im Gegensatz zur ersten, alle Dateien eines
	 * Verzeichnisses in ein Element zusammen.
	 * @param curTop "Vaterknoten"
	 * @param dir Verzeichnis
	 * @return fertigen Knoten
	 */

	private InterringNode addNodes2(InterringNode curTop, File dir) {		
		InterringNode curDir = new InterringNode(dir.getPath(),0);
		if (curTop != null) { // should only be null at root
			curTop.addChild(curDir);
		}
		File[] files = dir.listFiles();		
		// Array durchlaufen
		// - bei Verzeichnis: rekusiver Aufruf dieser Methode
		// - bei Datei: Zusammenfassen der Gren		
		long filelength = 0;
		for(int i = 0; i < files.length; i++){			
			if(files[i].isDirectory()){				
				addNodes2(curDir, files[i]);
			} else{
				filelength += files[i].length();						
			}		
		}		
		if(filelength > 0){
			InterringNode node = new InterringNode("Dateien",filelength);							
			curDir.addChild(node);
		}
		return curDir;
	}	
		
	/** Konstruktor
	 *  Der Konstruktor initialisiert alle Elemente der GUI und auch das Ausgabefenster.
	 * @param caption Fenstertitel
	 */
	public GUI_MainWindow(String caption) {
		super(caption);
		// Initialisieren von Variablen und Objekten
		fc_file = new JFileChooser();
		fc_file.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);			
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		// GUI-Elemente		
		// Menleiste
		JMenuBar menubar = new JMenuBar();
		// Men
		JMenu menu = new JMenu("Datei");
		menu.setMnemonic('D');
		// Meneintrag Datei - Mode 1
		mi_file = new JMenuItem("Datensatz (Verzeichnis - Dateien einzeln) laden", 'l');
		mi_file.addActionListener(this);
		// Meneintrag Datei - Mode 2
		mi_file2 = new JMenuItem("Datensatz (Verzeichnis - Dateien zusammengefasst) laden ", 't');
		mi_file2.addActionListener(this);		
		menu.add(mi_file2);
		menu.add(mi_file);
		// Meneintrag Output
		mi_output = new JMenuItem("Ausgabefenster anzeigen", 'a');
		mi_output.addActionListener(this);
		menu.add(mi_output);
		// Meneintrag Beenden		
		mi_exit = new JMenuItem("Beenden",'e');
		mi_exit.addActionListener(this);
		menu.add(mi_exit);
		//
		menubar.add(menu);
		//		
		this.setJMenuBar(menubar);
		//this.setBackground(Color.white);
		this.pack();
	    this.setVisible(true);	    
		this.setSize(new Dimension(800,60));
		this.setResizable(false);		
		this.output = new GUI_Output();
		this.output.setLocation(0,60);
	}

}
