/*
 * Decompiled with CFR 0.152.
 */
package interring;

import interring.ThicknessList;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.util.Vector;

public class GeometryNode {
    public Vector<GeometryNode> children;
    private String name;
    private long size;
    private double alpha;
    private double omega;
    private int distance2root;
    private boolean visible = true;
    private boolean children_visible;
    private boolean selected;

    public GeometryNode() {
        this.name = null;
        this.size = 0L;
        this.alpha = 0.0;
        this.omega = 360.0;
        this.distance2root = 0;
        this.children = new Vector();
        this.children_visible = true;
        this.selected = false;
    }

    public GeometryNode(double alpha, int distance2root, String name, long size, double omega) {
        this.name = name;
        this.size = size;
        this.alpha = alpha;
        this.omega = omega;
        this.distance2root = distance2root;
        this.children = new Vector();
        this.children_visible = true;
        this.selected = false;
    }

    public GeometryNode(String name, long size) {
        this.name = name;
        this.size = size;
        this.children = new Vector();
        this.alpha = 0.0;
        this.omega = 0.0;
        this.distance2root = 0;
    }

    public static void addChildren(GeometryNode node, GeometryNode[] nodes) {
        GeometryNode[] geometryNodeArray = nodes;
        int n = 0;
        int n2 = geometryNodeArray.length;
        while (n < n2) {
            GeometryNode element = geometryNodeArray[n];
            node.children.add(element);
            ++n;
        }
    }

    public void addChild(GeometryNode node) {
        this.children.add(node);
    }

    public boolean isleaf() {
        return this.getChildCount() == 0;
    }

    public long getBranchSize() {
        long cum_size = this.size;
        if (this.getChildCount() > 0) {
            int i = 0;
            while (i < this.children.size()) {
                cum_size += this.children.get(i).getBranchSize();
                ++i;
            }
        }
        return cum_size;
    }

    public void clearAllSelections() {
        this.selected = false;
        if (this.getChildCount() > 0) {
            int i = 0;
            while (i < this.children.size()) {
                this.children.get(i).clearAllSelections();
                ++i;
            }
        }
    }

    public GeometryNode search(int distance2root, double angle) {
        GeometryNode ret = null;
        if (this.distance2root == distance2root) {
            if (this.alpha < angle && this.omega > angle) {
                ret = this;
            }
        } else if (this.getChildCount() > 0) {
            int i = 0;
            while (i < this.children.size()) {
                GeometryNode candidate = this.children.get(i).search(distance2root, angle);
                if (candidate != null) {
                    ret = candidate;
                }
                ++i;
            }
        }
        return ret;
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        return this.size;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public GeometryNode getChildAt(int i) {
        return this.children.elementAt(i);
    }

    public int getIndexOfChild(GeometryNode node) {
        return this.children.indexOf(node);
    }

    public double getAlpha() {
        return this.alpha;
    }

    public int getDistance2root() {
        return this.distance2root;
    }

    public double getOmega() {
        return this.omega;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public void setDistance2root(int distance2root) {
        this.distance2root = distance2root;
    }

    public void setOmega(double omega) {
        this.omega = omega;
    }

    public int getMaxDepth() {
        int ret = this.distance2root;
        if (this.getChildCount() > 0) {
            int i = 0;
            while (i < this.children.size()) {
                int can = this.children.get(i).getMaxDepth();
                if (can > ret) {
                    ret = can;
                }
                ++i;
            }
        }
        return ret;
    }

    private Color getColor(double angle) {
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        if (angle >= 0.0 && angle < 120.0) {
            r = -((float)angle) / 120.0f + 1.0f;
            if (r < 0.0f) {
                r = 0.0f;
            }
            if ((g = (float)angle / 120.0f) > 1.0f) {
                g = 1.0f;
            }
        } else if (angle >= 120.0 && angle < 240.0) {
            g = -((float)angle - 120.0f) / 120.0f + 1.0f;
            if (g < 0.0f) {
                g = 0.0f;
            }
            if ((b = ((float)angle - 120.0f) / 120.0f) > 1.0f) {
                b = 1.0f;
            }
        } else if (angle >= 240.0 && angle <= 360.0) {
            b = -((float)angle - 240.0f) / 120.0f + 1.0f;
            if (b < 0.0f) {
                b = 0.0f;
            }
            if ((r = ((float)angle - 240.0f) / 120.0f) > 1.0f) {
                r = 1.0f;
            }
        }
        float brightness = 0.2f;
        r += brightness;
        g += brightness;
        b += brightness;
        if (r > 1.0f) {
            r = 1.0f;
        }
        if (g > 1.0f) {
            g = 1.0f;
        }
        if (b > 1.0f) {
            b = 1.0f;
        }
        return new Color(r, g, b);
    }

    public void setVisibility(boolean visible) {
        this.visible = visible;
    }

    public boolean getVisibility() {
        return this.visible;
    }

    public void toggleVisibilityOfChildren() {
        if (this.getChildCount() > 0) {
            int i = 0;
            while (i < this.children.size()) {
                this.children.get(i).setVisibility(!this.children.get(i).getVisibility());
                ++i;
            }
            this.children_visible = !this.children_visible;
        }
    }

    public void enableSelection() {
        this.selected = true;
    }

    public void drawIt(ThicknessList tlist, AffineTransform at, Graphics2D g2) {
        if (this.visible) {
            double outer = tlist.getRadius(this.distance2root + 1);
            Arc2D.Double segment = new Arc2D.Double(0.0 - outer, 0.0 - outer, 2.0 * outer, 2.0 * outer, this.alpha, this.omega - this.alpha, 2);
            double inner = tlist.getRadius(this.distance2root);
            Ellipse2D.Double whitespace = new Ellipse2D.Double(0.0 - inner, 0.0 - inner, 2.0 * inner, 2.0 * inner);
            Area areaSegment = new Area(segment);
            Area areaWhitespace = new Area(whitespace);
            areaSegment.subtract(areaWhitespace);
            g2.setPaint(this.getColor((this.alpha + this.omega) / 2.0));
            g2.fill(at.createTransformedShape(areaSegment));
            g2.setPaint(Color.BLACK);
            g2.draw(at.createTransformedShape(areaSegment));
            if (this.distance2root == 0) {
                g2.setPaint(this.getColor((this.alpha + this.omega) / 2.0));
                g2.fill(at.createTransformedShape(areaSegment));
            }
            if (this.getChildCount() > 0) {
                double o;
                double a;
                int i = 0;
                while (i < this.children.size()) {
                    this.children.get(i).drawIt(tlist, at, g2);
                    ++i;
                }
                if (!this.children_visible) {
                    Stroke temp = g2.getStroke();
                    BasicStroke stroke = new BasicStroke(5.0f, 2, 2);
                    g2.setStroke(stroke);
                    g2.setPaint(Color.WHITE);
                    a = this.alpha;
                    o = this.omega;
                    if (this.omega - this.alpha > 5.0) {
                        a = this.alpha + 1.5;
                        o = this.omega - 1.5;
                    }
                    double diff = Math.round(inner + (outer - inner) / 2.0);
                    Arc2D.Double segment2 = new Arc2D.Double(0.0 - diff, 0.0 - diff, 2.0 * diff, 2.0 * diff, a, o - a, 0);
                    g2.draw(at.createTransformedShape(segment2));
                    g2.setStroke(temp);
                }
                if (this.selected) {
                    double outer2 = outer - 1.0;
                    a = this.alpha;
                    o = this.omega;
                    if (this.omega - this.alpha > 5.0 && this.omega - this.alpha < 360.0) {
                        a = this.alpha + 1.5;
                        o = this.omega - 1.5;
                    }
                    Arc2D.Double segment2 = new Arc2D.Double(0.0 - outer2, 0.0 - outer2, 2.0 * outer2, 2.0 * outer2, a, o - a, 2);
                    double inner2 = inner + 1.0;
                    Ellipse2D.Double whitespace2 = new Ellipse2D.Double(0.0 - inner2, 0.0 - inner2, 2.0 * inner2, 2.0 * inner2);
                    Area areaSegment2 = new Area(segment2);
                    Area areaWhitespace2 = new Area(whitespace2);
                    areaSegment2.subtract(areaWhitespace2);
                    Stroke temp = g2.getStroke();
                    BasicStroke stroke = new BasicStroke(3.0f, 2, 2);
                    g2.setStroke(stroke);
                    g2.setPaint(Color.WHITE);
                    g2.draw(at.createTransformedShape(areaSegment2));
                    g2.setStroke(temp);
                }
            }
        }
    }
}

