/*
 * Decompiled with CFR 0.152.
 */
package interring;

import interring.GeometryNode;
import interring.InterringNode;
import interring.ThicknessList;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.JFrame;

public class GUI_Output
extends JFrame {
    private BufferStrategy bufferStrategy;
    private BufferedImage bimg;
    private GeometryNode geometry;
    private AffineTransform at;
    private ThicknessList thicknesslist;
    private GeometryNode selected;
    private double rotation = 0.0;
    private double scale = 1.0;
    private int translation_x = 0;
    private int translation_y = 0;
    private boolean mouse_button_left_down = false;
    private boolean mouse_button_right_down = false;
    private boolean distortion_mode = false;
    private boolean inner_edge = false;
    private int old_mouse_x = 0;
    private int old_mouse_y = 0;
    private int mouse_x = 0;
    private int mouse_y = 0;

    public GUI_Output() {
        super("IRing - Ausgabefenster");
        this.setDefaultCloseOperation(3);
        this.setBackground(Color.white);
        this.setLayout(null);
        this.pack();
        this.setSize(new Dimension(800, 600));
        this.createBufferStrategy(2);
        this.bufferStrategy = this.getBufferStrategy();
        this.addMouseListener(new MyMouseListener());
        this.addMouseMotionListener(new MyMouseMotionListener());
    }

    public Graphics2D createGraphics2D(int w, int h) {
        Graphics2D g2 = null;
        if (this.bimg == null || this.bimg.getWidth() != w || this.bimg.getHeight() != h) {
            this.bimg = (BufferedImage)this.createImage(w, h);
        }
        g2 = this.bimg.createGraphics();
        g2.setBackground(this.getBackground());
        g2.clearRect(0, 0, w, h);
        return g2;
    }

    private void drawInterring(Dimension d, Graphics2D g2) {
        if (this.bimg != null) {
            this.at = AffineTransform.getTranslateInstance(d.width / 2, d.height / 2);
            this.at.translate(this.translation_x, this.translation_y);
            this.at.scale(this.scale, this.scale);
            this.at.rotate(Math.toRadians(this.rotation));
            if (this.geometry == null) {
                Line2D.Double one = new Line2D.Double(-40.0, -40.0, 40.0, 40.0);
                Line2D.Double two = new Line2D.Double(-40.0, 40.0, 40.0, -40.0);
                g2.draw(this.at.createTransformedShape(one));
                g2.draw(this.at.createTransformedShape(two));
            } else {
                this.geometry.drawIt(this.thicknesslist, this.at, g2);
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        Dimension d = this.getSize();
        Graphics2D g2 = this.createGraphics2D(d.width, d.height);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        BasicStroke stroke = new BasicStroke(0.5f, 2, 2);
        g2.setStroke(stroke);
        this.drawInterring(d, g2);
        g2.dispose();
        Graphics2D g3 = (Graphics2D)this.bufferStrategy.getDrawGraphics();
        g3.drawImage((Image)this.bimg, 0, 0, this);
        if (this.mouse_button_left_down && this.selected != null) {
            int estimate = this.selected.getName().length() * 8;
            g3.drawRect(this.old_mouse_x - 3, this.old_mouse_y - 15, estimate, 23);
            g3.setPaint(new Color(240, 220, 160, 170));
            g3.fillRect(this.old_mouse_x - 3, this.old_mouse_y - 15, estimate, 23);
            g3.setPaint(Color.black);
            g3.drawString(this.selected.getName(), this.old_mouse_x, this.old_mouse_y);
        }
        g3.dispose();
        this.bufferStrategy.show();
    }

    public void setGeometry(InterringNode interring) {
        this.geometry = this.generateGeometry(null, interring, 0, 0.0, interring.getBranchSize());
        this.thicknesslist = new ThicknessList(this.geometry.getMaxDepth() + 1, 20.0, 5.0);
    }

    private GeometryNode generateGeometry(GeometryNode curTop, InterringNode interring, int distance2root, double alpha, long father_size) {
        Vector<InterringNode> vec;
        double omega = alpha + 360.0 * (double)interring.getBranchSize() / (double)father_size;
        GeometryNode curDir = new GeometryNode(alpha, distance2root, interring.getName(), interring.getBranchSize(), omega);
        if (curTop != null) {
            curTop.addChild(curDir);
        }
        if ((vec = interring.children).size() > 0) {
            int i = 0;
            while (i < vec.size()) {
                InterringNode irnode = vec.get(i);
                if (irnode.getChildCount() > 0) {
                    this.generateGeometry(curDir, vec.get(i), distance2root + 1, alpha, father_size);
                    alpha = omega = alpha + 360.0 * (double)vec.get(i).getBranchSize() / (double)father_size;
                } else {
                    omega = alpha + 360.0 * (double)vec.get(i).getBranchSize() / (double)father_size;
                    GeometryNode node = new GeometryNode(alpha, distance2root + 1, vec.get(i).getName(), father_size, omega);
                    curDir.addChild(node);
                    alpha = omega;
                }
                ++i;
            }
        }
        curDir.setOmega(omega);
        return curDir;
    }

    private GeometryNode getCandidate(double x, double y) {
        Point2D.Double p = new Point2D.Double(x, y);
        Point2D ip = null;
        int distance2root = 0;
        double angle = 0.0;
        try {
            ip = this.at.inverseTransform(p, null);
            double dist = Math.sqrt(ip.getX() * ip.getX() + ip.getY() * ip.getY());
            distance2root = this.thicknesslist.getLayer(dist);
            this.inner_edge = this.thicknesslist.isInnerBorder(distance2root, dist);
            x = ip.getX() / dist;
            y = ip.getY() / -dist;
            angle = Math.toDegrees(Math.acos(x));
            if (y < 0.0) {
                angle = 360.0 - angle;
            }
        }
        catch (Exception dist) {
            // empty catch block
        }
        GeometryNode node = null;
        if (this.geometry != null && distance2root > -1) {
            node = this.geometry.search(distance2root, angle);
        }
        return node;
    }

    class MyMouseListener
    extends MouseAdapter {
        MyMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (event.getButton() == 1) {
                GUI_Output.this.mouse_button_left_down = true;
                GUI_Output.this.old_mouse_x = event.getX();
                GUI_Output.this.old_mouse_y = event.getY();
                GeometryNode newselected = GUI_Output.this.getCandidate(GUI_Output.this.old_mouse_x, GUI_Output.this.old_mouse_y);
                if (GUI_Output.this.selected == null) {
                    GUI_Output.this.selected = newselected;
                } else if (GUI_Output.this.selected.equals(newselected)) {
                    GUI_Output.this.distortion_mode = true;
                } else {
                    GUI_Output.this.selected = newselected;
                    GUI_Output.this.distortion_mode = false;
                }
                if (GUI_Output.this.selected != null) {
                    GUI_Output.this.repaint();
                }
                if (event.getClickCount() > 1 && GUI_Output.this.selected != null) {
                    GUI_Output.this.selected.toggleVisibilityOfChildren();
                } else if (GUI_Output.this.selected != null) {
                    GUI_Output.this.geometry.clearAllSelections();
                    GUI_Output.this.selected.enableSelection();
                } else {
                    GUI_Output.this.geometry.clearAllSelections();
                }
            }
            if (event.getButton() == 3) {
                GUI_Output.this.mouse_button_right_down = true;
                GUI_Output.this.old_mouse_x = event.getX();
                GUI_Output.this.old_mouse_y = event.getY();
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (event.getButton() == 1) {
                GUI_Output.this.mouse_button_left_down = false;
                GUI_Output.this.repaint();
            }
            if (event.getButton() == 3) {
                GUI_Output.this.mouse_button_right_down = false;
            }
        }
    }

    class MyMouseMotionListener
    extends MouseMotionAdapter {
        MyMouseMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            if (GUI_Output.this.mouse_button_right_down) {
                GUI_Output.this.mouse_x = event.getX();
                GUI_Output.this.mouse_y = event.getY();
                GUI_Output gUI_Output = GUI_Output.this;
                gUI_Output.rotation = gUI_Output.rotation + (double)((GUI_Output.this.mouse_x - GUI_Output.this.old_mouse_x) / 2);
                GUI_Output gUI_Output2 = GUI_Output.this;
                gUI_Output2.scale = gUI_Output2.scale - ((double)GUI_Output.this.mouse_y - (double)GUI_Output.this.old_mouse_y) / 100.0;
                if (GUI_Output.this.scale < 0.0) {
                    GUI_Output.this.scale = 0.01;
                }
                GUI_Output.this.old_mouse_x = GUI_Output.this.mouse_x;
                GUI_Output.this.old_mouse_y = GUI_Output.this.mouse_y;
                GUI_Output.this.repaint();
            }
            if (GUI_Output.this.mouse_button_left_down) {
                if (!GUI_Output.this.distortion_mode) {
                    GUI_Output.this.mouse_x = event.getX();
                    GUI_Output.this.mouse_y = event.getY();
                    GUI_Output gUI_Output = GUI_Output.this;
                    gUI_Output.translation_x = gUI_Output.translation_x + (GUI_Output.this.mouse_x - GUI_Output.this.old_mouse_x);
                    GUI_Output gUI_Output3 = GUI_Output.this;
                    gUI_Output3.translation_y = gUI_Output3.translation_y + (GUI_Output.this.mouse_y - GUI_Output.this.old_mouse_y);
                    GUI_Output.this.old_mouse_x = GUI_Output.this.mouse_x;
                    GUI_Output.this.old_mouse_y = GUI_Output.this.mouse_y;
                    GUI_Output.this.repaint();
                } else {
                    GUI_Output.this.mouse_x = event.getX();
                    GUI_Output.this.mouse_y = event.getY();
                    int diff_y = GUI_Output.this.mouse_y - GUI_Output.this.old_mouse_y;
                    int diff_x = GUI_Output.this.mouse_x - GUI_Output.this.old_mouse_x;
                    int len = diff_y - diff_x;
                    GUI_Output.this.thicknesslist.modify(GUI_Output.this.selected.getDistance2root(), len, GUI_Output.this.inner_edge);
                    GUI_Output.this.old_mouse_x = GUI_Output.this.mouse_x;
                    GUI_Output.this.old_mouse_y = GUI_Output.this.mouse_y;
                    GUI_Output.this.repaint();
                }
            }
        }
    }
}

