#version 330

layout(location = 0) in vec4 position;
layout(location = 1) in vec2 texCoords;

layout(std140) uniform GlobalMatrices
{
	uniform mat4 perspectiveViewMatrix;
	uniform vec2 windowDimensions;
};

smooth out vec2 vTexCoords;
uniform mat4 modelMatrix;

void main()
{
    vTexCoords = texCoords;
	gl_Position = perspectiveViewMatrix * modelMatrix * position;
}