﻿#version 120

#define MAX_LIGHTS 8
#define NUM_LIGHTS 2

//PHONG SHADER WITH MULTIPLE LIGHTS
varying vec3 normal,eyeVec;
varying vec3 vertex_to_light_vector;
varying vec3 lightDir[MAX_LIGHTS];

void main()
{
    // Transforming The Vertex
	gl_Position = ftransform();	
    
	vec4 vVertex = gl_ModelViewMatrix * gl_Vertex;
    normal = gl_NormalMatrix * gl_Normal;
 
    // Transforming The Vertex Position To ModelView-Space
	eyeVec = -vVertex.xyz;
	int i;
	for (i=0; i<NUM_LIGHTS; ++i) {
		lightDir[i] = vec3(gl_LightSource[i].position.xyz - vVertex.xyz);
	}
}